package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.CadastroHabilidadeDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class CadastroHabilidadeDao extends CrudDaoDefaultImpl {

	public CadastroHabilidadeDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<CadastroHabilidadeDTO> find(IDto obj) throws PersistenceException {
		List<Order> ordem = new ArrayList<Order>();
		ordem.add(new Order("nomehabilidade"));
		return super.find(obj, ordem);
	}

	@Override
	public Class<CadastroHabilidadeDTO> getBean() {
		return CadastroHabilidadeDTO.class;
	}

	@Override
	public List<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("IDHABILIDADE", "IdHabilidade", true, true, false, false));
		listFields.add(new Field("DESCRICAO", "descricao", false, false, false, false));
		listFields.add(new Field("NOMEHABILIDADE", "nomeHabilidade", false, false, false, false));
		listFields.add(new Field("DATAHORAINICIO", "dataHoraInicio", false, false, false, false));
		listFields.add(new Field("DATAHORAFIM", "dataHoraFim", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "HABILIDADE";
	}

	public Collection<CadastroHabilidadeDTO> verificaHabilidade(CadastroHabilidadeDTO cadastroHabilidadeDTO) throws PersistenceException{
		final StringBuilder sql = new StringBuilder();
		final List<Object> listFields = new ArrayList<>();

		List<?> list = new ArrayList<>();

		final List<String> parametro = new ArrayList<String>();

		sql.append(" SELECT hab.nomehabilidade,");
		sql.append("        hab.idhabilidade");
		sql.append(" FROM   habilidade hab ");
		sql.append(" WHERE  hab.nomehabilidade = ? ");
		sql.append(" AND    hab.datahorafim is null");
		sql.append(" ORDER  BY hab.nomehabilidade ");

		parametro.add(cadastroHabilidadeDTO.getNomeHabilidade());

		list = this.execSQL(sql.toString(), parametro.toArray());

		listFields.add("nomeHabilidade");
		listFields.add("idHabilidade");

		Collection<CadastroHabilidadeDTO> listaRetorno = null;

		if (list != null && !list.isEmpty()) {
			listaRetorno = this.listConvertion(this.getBean(), list, listFields);
		} else {
			listaRetorno = new ArrayList<CadastroHabilidadeDTO>();
		}

		return listaRetorno;
	}

	@SuppressWarnings("unchecked")
	public Collection<CadastroHabilidadeDTO> getListHabilidadesByIdServico(Integer idServico) throws PersistenceException {
		final List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idServico", idServico));
		condicao.add(new Condition("dataFim", Condition.IS, null));

		final List<Order> ordenacao = new ArrayList<Order>();

		return this.findByCondition(condicao, ordenacao);
	}

}
