package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.CadastroTemplateIncidenteRequisicaoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

@SuppressWarnings("unchecked")
public class CadastroTemplateIncidenteRequisicaoDAO extends CrudDaoDefaultImpl {
	public CadastroTemplateIncidenteRequisicaoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "templateincidenterequisicao";
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idtemplateincidenterequisicao", "idTemplateIncidenteRequisicao", true, true, false, false));
		listFields.add(new Field("nometemplate", "nomeTemplate", false, false, false, false));
		listFields.add(new Field("idcontrato", "idContrato", false, false, false, false));
		listFields.add(new Field("idorigem", "idOrigem", false, false, false, false));
		listFields.add(new Field("idsolicitante", "idSolicitante", false, false, false, false));
		listFields.add(new Field("idtipodemandaservico", "idTipoDemandaServico", false, false, false, false));
		listFields.add(new Field("idservico", "idServico", false, false, false, false));
		listFields.add(new Field("descricao", "descricao", false, false, false, false));
		listFields.add(new Field("impacto", "impacto", false, false, false, false));
		listFields.add(new Field("urgencia", "urgencia", false, false, false, false));
		listFields.add(new Field("idgrupo", "idGrupo", false, false, false, false));
		listFields.add(new Field("enviaemailcriacao", "enviaEmailCriacao", false, false, false, false));
		listFields.add(new Field("enviaemailfinalizacao", "enviaEmailFinalizacao", false, false, false, false));
		listFields.add(new Field("enviaemailacoes", "enviaEmailAcoes", false, false, false, false));
		listFields.add(new Field("emailsolicitante", "emailSolicitante", false, false, false, false));
		listFields.add(new Field("idunidade", "idUnidade", false, false, false, false));
		listFields.add(new Field("idlocalidade", "idLocalidade", false, false, false, false));
		listFields.add(new Field("idcategoriaservico", "idCategoriaServico", false, false, false, false));
		listFields.add(new Field("idtipocatalogoservicosoli", "idTipoCatalogoServicoSoli", false, false, false, false));
		listFields.add(new Field("idserviconegociotecbusc", "idServicoNegocioTecBusc", false, false, false, false));
		listFields.add(new Field("utilizacategoriaservico", "utilizaCategoriaServico", false, false, false, false));
		listFields.add(new Field("datainicio", "dataInicio", false, false, false, false));
		listFields.add(new Field("datafim", "dataFim", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<CadastroTemplateIncidenteRequisicaoDTO> getBean() {
		return CadastroTemplateIncidenteRequisicaoDTO.class;
	}

	@Override
	public Collection<CadastroTemplateIncidenteRequisicaoDTO> list() throws PersistenceException {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();

		condicao.add(new Condition("dataFim", "is", null));
		ordenacao.add(new Order("nomeTemplate"));

		return this.findByCondition(condicao, ordenacao);
	}
}