package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.CadastroTemplateIncidenteRequisicaoICDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

@SuppressWarnings("unchecked")
public class CadastroTemplateIncidenteRequisicaoICDAO extends CrudDaoDefaultImpl {
	public CadastroTemplateIncidenteRequisicaoICDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "templateincidentereqic";
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idtemplateincidentereqic", "idTemplateIncidenteReqIC", true, true, false, false));
		listFields.add(new Field("idtemplateincidenterequisicao", "idTemplateIncidenteRequisicao", false, false, false, false));
		listFields.add(new Field("iditemconfiguracao", "idItemConfiguracao", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<CadastroTemplateIncidenteRequisicaoICDTO> getBean() {
		return CadastroTemplateIncidenteRequisicaoICDTO.class;
	}

	public Collection<CadastroTemplateIncidenteRequisicaoICDTO> listByIdTemplateIncidenteRequisicao(Integer idTemplateIncidenteRequisicao) throws PersistenceException {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> order = new ArrayList<>();

		condicao.add(new Condition("idTemplateIncidenteRequisicao", idTemplateIncidenteRequisicao));
		order.add(new Order("idTemplateIncidenteRequisicao"));

		return super.findByCondition(condicao, order);
	}

	public void deleteByIdTemplateIncidenteRequisicao(Integer idTemplateIncidenteRequisicao) throws PersistenceException {
		final List<Condition> condicao = new ArrayList<>();
		condicao.add(new Condition("idTemplateIncidenteRequisicao", idTemplateIncidenteRequisicao));

		super.deleteByCondition(condicao);
	}
}