package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import br.com.centralit.citcorpore.bean.AtributosFinanceirosDTO;
import br.com.centralit.citcorpore.bean.CadastroTipoFinanceiroDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class CadastroTipoFinanceiroDao extends CrudDaoDefaultImpl {

	public CadastroTipoFinanceiroDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Class getBean() {
		return CadastroTipoFinanceiroDTO.class;
	}

	@Override
	public List<Field> getFields() {
		List<Field> listFields = new ArrayList<>();

		listFields.add(new Field("IDTIPO", "idTipo", true, true, false, false));
		listFields.add(new Field("NOMETIPO", "nomeTipo", false, false, false, false));
		listFields.add(new Field("PERFIL", "perfil", false, false, false, false));
		listFields.add(new Field("DATAFIM", "dataFim", false, false, false, false));
		listFields.add(new Field("classificacao", "classificacaoTipo", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "TIPOFINANCEIROSERVICO";
	}
	
	public Collection<AtributosFinanceirosDTO> listaTiposPorPerfil(final String perfil) throws PersistenceException {
		final StringBuilder sql = new StringBuilder();
		final List<Object> listFields = new ArrayList<>();

		List list = new ArrayList<>();

		final List parametro = new ArrayList<>();

		sql.append(" SELECT tipofinan.nometipo,");
		sql.append("        tipofinan.idtipo");
		sql.append(" FROM   tipofinanceiroservico tipofinan ");
		sql.append(" WHERE  tipofinan.perfil = ? ");
		sql.append(" ORDER  BY tipofinan.nometipo ");

		parametro.add(perfil);

		list = this.execSQL(sql.toString(), parametro.toArray());

		listFields.add("nomeTipo");
		listFields.add("idTipo");

		Collection<AtributosFinanceirosDTO> listaRetorno = null;

		if (list != null && !list.isEmpty()) {
			listaRetorno = this.listConvertion(this.getBean(), list, listFields);
		} else {
			listaRetorno = new ArrayList<AtributosFinanceirosDTO>();
		}

		return listaRetorno;
	}
	
	public Collection verificaTipofinanceiro(CadastroTipoFinanceiroDTO cadastroTipoFinanceiroDTO) throws PersistenceException{
		final StringBuilder sql = new StringBuilder();
		final List<Object> listFields = new ArrayList<>();

		List list = new ArrayList<>();

		final List parametro = new ArrayList<>();

		sql.append(" SELECT tipofinan.nometipo,");
		sql.append("        tipofinan.perfil");
		sql.append(" FROM   tipofinanceiroservico tipofinan ");
		sql.append(" WHERE  tipofinan.perfil = ? ");
		sql.append(" AND    tipofinan.nometipo = ?");
		sql.append(" AND    tipofinan.datafim is null");
		sql.append(" ORDER  BY tipofinan.nometipo ");

		parametro.add(cadastroTipoFinanceiroDTO.getPerfil());
		parametro.add(cadastroTipoFinanceiroDTO.getNomeTipo());

		list = this.execSQL(sql.toString(), parametro.toArray());

		listFields.add("nomeTipo");
		listFields.add("idTipo");
		
		Collection<CadastroTipoFinanceiroDTO> listaRetorno = null;
		
		if (list != null && !list.isEmpty()) {
			listaRetorno = this.listConvertion(this.getBean(), list, listFields);
		} else {
			listaRetorno = new ArrayList<CadastroTipoFinanceiroDTO>();
		}
		return listaRetorno;
	}
	
	public CadastroTipoFinanceiroDTO getPerfil(Integer idTipo) throws PersistenceException{
		
		final StringBuilder sql = new StringBuilder();
		final List<Object> listFields = new ArrayList<>();

		List list = new ArrayList<>();

		final List parametro = new ArrayList<>();

		sql.append(" SELECT tipofinan.perfil");
		sql.append(" FROM   tipofinanceiroservico tipofinan ");
		sql.append(" WHERE  tipofinan.idTipo = ? ");

		parametro.add(idTipo);

		list = this.execSQL(sql.toString(), parametro.toArray());

		listFields.add("nomeTipo");
		listFields.add("idTipo");
		
		CadastroTipoFinanceiroDTO cadastroTipoFinanceiroDTO = (CadastroTipoFinanceiroDTO) this.listConvertion(this.getBean(), list, listFields);
		
		return cadastroTipoFinanceiroDTO;
	}
	
	public Map<String, Integer> getSetNomeCategoria() throws Exception{
		List condicao = new ArrayList();
		List ordem = new ArrayList();
		Collection retorno = this.findByCondition(condicao, ordem);
		Map<String, Integer> mapTipoCategoria = new HashMap<>();
		if(retorno != null){
			List<CadastroTipoFinanceiroDTO> listCadastroTipoFinanceiroDTO = new ArrayList<>(retorno);
			for(CadastroTipoFinanceiroDTO cadastroTipoFinanceiroDTO : listCadastroTipoFinanceiroDTO){
				mapTipoCategoria.put(cadastroTipoFinanceiroDTO.getNomeTipo(), cadastroTipoFinanceiroDTO.getIdTipo());
			}
		}
		return mapTipoCategoria;
	}
}