package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.CasoNegocioDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

/**
 * @author ibimon.morais
 * @02/10/2015
 */
public class CasoNegocioDao extends CrudDaoDefaultImpl {
	private static final String TABLE_NAME = "casonegocio";

	public CasoNegocioDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return TABLE_NAME;
	}

	@Override
	public Collection<Field> getFields() {
		final Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idcasonegocio", "idCasoNegocio", true, true, false, false));
		listFields.add(new Field("nomecasonegocio", "nomeCasoNegocio", false, false, false, false));
		listFields.add(new Field("idservicocasonegocio", "idServico", false, false, false, false));
		listFields.add(new Field("descricaosumarioexecutivo", "descricaoSumarioExecutivo", false, false, false, false));
		listFields.add(new Field("descricaocenarios", "descricaoCenarios", false, false, false, false));
		listFields.add(new Field("descricaoproblemaoportunidade", "descricaoProblemaOportunidade", false, false, false, false));
		listFields.add(new Field("descricaopropostasolucao", "descricaoPropostaSolucao", false, false, false, false));
		listFields.add(new Field("descricaoanalisefinanceira", "descricaoAnaliseFinanceira", false, false, false, false));
		listFields.add(new Field("descricaoanaliserisco", "descricaoAnaliseRisco", false, false, false, false));
		listFields.add(new Field("descricaostakeholderentidade", "descricaoStakeholderEntidade", false, false, false, false));
		listFields.add(new Field("descricaoviabilidadetecnica", "descricaoViabilidadeTecnica", false, false, false, false));
		listFields.add(new Field("descricaoconclusao", "descricaoConclusao", false, false, false, false));
		listFields.add(new Field("datafim", "dataFim", false, false, false, false));

		return listFields;
	}
	
	/**
	 * br.com.centralit.citcorpore.integracao.CasoNegocioDao.java_(#findByIdServico)
	 * @since 23/10/2015
	 * @author ibimon.morais
	 */
	@SuppressWarnings({ "unchecked" })
	public Collection<CasoNegocioDTO> findByIdServico(final Integer parm) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List<?> list = new ArrayList<>();
		// Param
		Object[] obj = new Object[1];
		obj[0] = parm;

		sql.append("SELECT  idcasonegocio , ");
		sql.append("nomecasonegocio , ");
		sql.append("idservicocasonegocio ,  ");
		sql.append("descricaosumarioexecutivo , ");
		sql.append("descricaocenarios ,  ");
		sql.append("descricaoproblemaoportunidade , ");
		sql.append("descricaopropostasolucao ,  ");
		sql.append("descricaoanalisefinanceira , ");
		sql.append("descricaoanaliserisco ,  ");
		sql.append("descricaostakeholderentidade , ");
		sql.append("descricaoviabilidadetecnica , ");
		sql.append("descricaoconclusao ,  ");
		sql.append("datafim  FROM casonegocio WHERE idservicocasonegocio = ? and datafim is null ");
		// Fields
		list = this.execSQL(sql.toString(), obj);
		return (ArrayList<CasoNegocioDTO>) this.listConvertion(getBean(), list, this.getListNamesFieldClass());
	}

	@Override
	public void delete(final IDto obj) throws PersistenceException {
		super.delete(obj);
	}

	@Override
	public Class<CasoNegocioDTO> getBean() {
		return CasoNegocioDTO.class;
	}
}
