package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.CatalogoServicoDTO;
import br.com.centralit.citcorpore.bean.InfoCatalogoServicoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.core.DataBase;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.PageImpl;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.integracao.core.PagingQueryUtil;
import br.com.citframework.util.Constantes;

/**
 * 
 * @author pedro
 *
 */

@SuppressWarnings({ "rawtypes", "unchecked" })
public class CatalogoServicoDao extends CrudDaoDefaultImpl {

	/**
     * 
     */
	public CatalogoServicoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}
	
	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		
		listFields.add(new Field("idCatalogoServico", "idCatalogoServico", true, true, false, false));
		listFields.add(new Field("tituloCatalogoServico", "tituloCatalogoServico", false, false, false, false));
		listFields.add(new Field("idContrato", "idContrato", false, false, false, false));
		listFields.add(new Field("dataInicio", "dataInicio", false, false, false, false));
		listFields.add(new Field("dataFim", "dataFim", false, false, false, false));
		listFields.add(new Field("obs", "obs", false, false, false, false));
		listFields.add(new Field("nomeServico", "nomeServico", false, false, false, false));
		
		return listFields;
	}
	
	@Override
	public String getTableName() {
		return "CATALOGOSERVICO";
	}

	@Override
	public Collection find(IDto obj) throws PersistenceException {
		List ordem = new ArrayList();

		return super.find(obj, ordem);
	}
	
	@Override
	public Collection list() throws PersistenceException {
		List list = new ArrayList();

		return super.list(list);
	}
	
	public Collection<CatalogoServicoDTO> listAllCatalogos() throws PersistenceException {
		List parametro = new ArrayList();
		String sql = "SELECT idCatalogoServico, tituloCatalogoServico FROM " + getTableName() + "  WHERE dataFim IS NULL";
		List<InfoCatalogoServicoDTO> dados = this.execSQL(sql, parametro.toArray());
		List<String> fields = new ArrayList<String>();
		fields.add("idCatalogoServico");
		fields.add("tituloCatalogoServico");
		return this.listConvertion(getBean(), dados, fields);
	}
	
	public boolean verificaSeCatalogoExiste(CatalogoServicoDTO catalogoServicoDTO) throws PersistenceException {
		
		List parametro = new ArrayList();
		List list = new ArrayList();
		StringBuilder sql = new StringBuilder();
		sql.append("select idCatalogoServico from " + getTableName() + "  where  tituloCatalogoServico = ? and datafim is null ");
		parametro.add(catalogoServicoDTO.getTituloCatalogoServico());

		if (catalogoServicoDTO.getIdCatalogoServico() != null) {
			sql.append("and idCatalogoServico <> ?");
			parametro.add(catalogoServicoDTO.getIdCatalogoServico());
		}
		list = this.execSQL(sql.toString(), parametro.toArray());

		if (list != null && !list.isEmpty()) {
			return true;
		} else {
			return false;
		}
	}
	
	@Override
	public Class getBean() {
		return CatalogoServicoDTO.class;
	}
	
	public Collection<CatalogoServicoDTO> listByIdContrato(Integer idContrato) throws PersistenceException {
		List parametro = new ArrayList();
		String sql = "SELECT idCatalogoServico, idContrato, tituloCatalogoServico FROM " + getTableName() + "  WHERE dataFim IS NULL AND  idcontrato = ?";
		parametro.add(idContrato);
		List<InfoCatalogoServicoDTO> dados = this.execSQL(sql, parametro.toArray());
		List<String> fields = new ArrayList<String>();
		fields.add("idCatalogoServico");
		fields.add("idContrato");
		fields.add("tituloCatalogoServico");
		return this.listConvertion(getBean(), dados, fields);
	}
	
	public Page<CatalogoServicoDTO> listByIdPortfolioAndSituacao(Integer idPortfolio, Integer idSituacao, String filtroServico, Pageable pageable, Boolean isTotalizacao) throws PersistenceException {
		Page<CatalogoServicoDTO> taskPage;
		
		StringBuilder selectQueryPiece = new StringBuilder("SELECT ");
		selectQueryPiece.append("	idcatalogoservico, ");
		selectQueryPiece.append("	titulocatalogoservico ");

		StringBuilder orderBy = new StringBuilder("ORDER BY titulocatalogoservico ");

		StringBuilder fromWhereQueryPiece = new StringBuilder("FROM ");
		fromWhereQueryPiece.append("	catalogoservico ");
		fromWhereQueryPiece.append("WHERE ");
		fromWhereQueryPiece.append(" 1 = 1");
		fromWhereQueryPiece.append(" and 1 = 1 ");
		
		if (filtroServico != "") {
			try {
				Integer idCatalogoServico = Integer.parseInt(filtroServico);
				fromWhereQueryPiece.append(" and (idcatalogoservico = " + idCatalogoServico + " ");
				fromWhereQueryPiece.append(" or upper(titulocatalogoservico) like upper('%" + filtroServico + "%')) ");
			} catch(Exception e) {
				fromWhereQueryPiece.append(" and upper(titulocatalogoservico) like upper('%" + filtroServico + "%') ");
			}
		} 
		
		String sql = "";
		List lista = new ArrayList();
		if (!isTotalizacao) {
			if (MAIN_SGBD.equals(DataBase.MSSQLSERVER)) {
				sql = PagingQueryUtil.constructsSQLServerPagingPiece(pageable, selectQueryPiece.toString(), orderBy.toString(), fromWhereQueryPiece.toString());
			} else {
				selectQueryPiece.append(fromWhereQueryPiece);
				selectQueryPiece.append(orderBy);
				sql = PagingQueryUtil.concatPagingPieceOnQuery(pageable, selectQueryPiece.toString(), MAIN_SGBD);
			}

			lista = this.execSQL(sql, null);

			List<String> listRetorno = new ArrayList<String>();
			listRetorno.add("idCatalogoServico");
			listRetorno.add("tituloCatalogoServico");

			List<CatalogoServicoDTO> result = this.engine.listConvertion(getBean(), lista, listRetorno);
			taskPage = new PageImpl<CatalogoServicoDTO>(result, pageable, 1L);
		} else {
			final StringBuilder sqlCount = this.countQueryPiece(fromWhereQueryPiece);
			final Long totalElements = this.countElements(sqlCount.toString(), null);
			final List<CatalogoServicoDTO> result = new ArrayList<CatalogoServicoDTO>();
			taskPage = this.makePage(result, pageable, totalElements);
		}
		
		return taskPage;
	}


	public Collection<CatalogoServicoDTO> findByIdServico(Integer idServico) throws Exception {
		StringBuilder sql = new StringBuilder();
		sql.append("select distinct idcatalogoservico, titulocatalogoservico from catalogonegociomapaimg catimg inner join catalogoservico catser on catimg.idcatalogonegocio = catser.idcatalogoservico where idservico = ?");

		List parametro = new ArrayList();
		parametro.add(idServico);

		List listRetorno = new ArrayList();
		listRetorno.add("idCatalogoServico");
		listRetorno.add("tituloCatalogoServico");

		List list = execSQL(sql.toString(), parametro.toArray());
		if (list != null && !list.isEmpty()) {
			return this.listConvertion(CatalogoServicoDTO.class, list, listRetorno);
		}

		return null;
	}

}
