package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AmeacaDTO;
import br.com.centralit.citcorpore.bean.CategoriaAmeacaDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class CategoriaAmeacaDao extends CrudDaoDefaultImpl {

	public CategoriaAmeacaDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public List<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("IDCATEGORIAAMEACA", "idCategoriaAmeaca", true, true, false, false));
		listFields.add(new Field("NOMECATEGORIAAMEACA", "nomeCategoriaAmeaca", false, false, false, false));
		listFields.add(new Field("DATAFIM", "dataFim", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "CATEGORIAAMEACA";
	}

	@Override
	public Class<CategoriaAmeacaDTO> getBean() {
		return CategoriaAmeacaDTO.class;
	}

	@SuppressWarnings("unchecked")
	public Collection<CategoriaAmeacaDTO> getListAmeacasByNome(String nome) throws PersistenceException {
		final List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("nomeCategoriaAmeaca", nome));
		condicao.add(new Condition("dataFim", Condition.IS, null));

		final List<Order> ordenacao = new ArrayList<Order>();

		return this.findByCondition(condicao, ordenacao);
	}
	
	public AmeacaDTO getCategoriaAmeacaById(Integer idCategoriaAmeaca) throws PersistenceException {
		final StringBuilder sql = new StringBuilder();
		final List<Object> listFields = new ArrayList<>();

		List<?> list = new ArrayList<>();

		final List<Integer> parametro = new ArrayList<Integer>();

		sql.append(" SELECT cat.nomecategoriaameaca");
		sql.append(" FROM   categoriaameaca cat ");
		sql.append(" WHERE  cat.idcategoriaameaca = ? ");
		sql.append(" AND    cat.datafim is null");

		parametro.add(idCategoriaAmeaca);

		list = this.execSQL(sql.toString(), parametro.toArray());

		listFields.add("nomeCategoriaAmeaca");

		ArrayList<AmeacaDTO> listaRetorno = null;

		if (list != null && !list.isEmpty()) {
			listaRetorno = (ArrayList<AmeacaDTO>) this.listConvertion(this.getBean(), list, listFields);
		} else {
			listaRetorno = new ArrayList<AmeacaDTO>();
		}

		return listaRetorno.get(0);
	}
}
