package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;

import br.com.centralit.citcorpore.bean.CategoriaRiscoDTO;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

/**
 * @since 29.01.2016
 * @author gustavo.gomes
 */

public class CategoriaRiscoDAO extends CrudDaoDefaultImpl {

	public CategoriaRiscoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "CATEGORIARISCO";
	}

	@Override
	public Collection<Field> getFields() {
		final Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idCategoriaRisco", "idCategoriaRisco", true, true, false, false));
		listFields.add(new Field("nome", "nome", false, false, false, true));
		listFields.add(new Field("tag", "tag", false, false, false, false));
		listFields.add(new Field("cor", "cor", false, false, false, false));
		listFields.add(new Field("icone", "icone", false, false, false, false));
		listFields.add(new Field("dataFim", "dataFim", false, false, false, false));
		return listFields;
	}

	@Override
	public Class<?> getBean() {
		return CategoriaRiscoDTO.class;
	}

}
