/**
 * CentralIT - CITSmart
 */
package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import br.com.centralit.citcorpore.bean.CategoriaServicoDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados.TipoCategoria;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.SQLConfig;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilNumbersAndDecimals;

/**
 * @author rosana.godinho
 */
@SuppressWarnings({ "rawtypes", "unchecked" })
public class CategoriaServicoDao extends CrudDaoDefaultImpl {

	public CategoriaServicoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idCategoriaServico", "idCategoriaServico", true, true, false, false));
		listFields.add(new Field("idCategoriaServicoPai", "idCategoriaServicoPai", false, false, false, false));
		listFields.add(new Field("idEmpresa", "idEmpresa", false, false, false, false));
		listFields.add(new Field("nomeCategoriaServico", "nomeCategoriaServico", false, false, false, false));
		listFields.add(new Field("DataInicio", "dataInicio", false, false, false, false));
		listFields.add(new Field("DataFim", "dataFim", false, false, false, false));
		listFields.add(new Field("nomeCategoriaServicoConcatenado", "nomeCategoriaServicoConcatenado", false, false, false, false));
		listFields.add(new Field("tipoCategoria", "tipoCategoria", false, false, false, false));


		return listFields;
	}

	@Override
	public String getTableName() {
		return "CATEGORIASERVICO";
	}

	@Override
	public Collection find(IDto obj) throws PersistenceException {
		return null;
	}

	@Override
	public Collection list() throws PersistenceException {
		List list = new ArrayList();
		list.add(new Order("nomeCategoriaServico"));
		return super.list(list);
	}

	@Override
	public Class getBean() {
		return CategoriaServicoDTO.class;
	}
	public Collection findSemPai() throws PersistenceException {
		String sql = "SELECT idCategoriaServico, idCategoriaServicoPai, idEmpresa, nomeCategoriaServico, DataInicio FROM CATEGORIASERVICO WHERE idCategoriaServicoPai IS NULL AND dataFim IS NULL ORDER BY nomeCategoriaServico ";
		List colDados = this.execSQL(sql, null);
		if (colDados != null) {
			List fields = new ArrayList();
			fields.add("idCategoriaServico");
			fields.add("idCategoriaServicoPai");
			fields.add("idEmpresa");
			fields.add("nomeCategoriaServico");
			fields.add("dataInicio");
			return this.listConvertion(CategoriaServicoDTO.class, colDados, fields);
		}
		return null;
	}
	
	public Collection findSemPaiRelacionadoAoServico() throws PersistenceException {
		String sql = "SELECT idCategoriaServico, idCategoriaServicoPai, idEmpresa, nomeCategoriaServico, DataInicio FROM CATEGORIASERVICO WHERE idCategoriaServicoPai IS NULL AND dataFim IS NULL ORDER BY nomeCategoriaServico ";
		List colDados = this.execSQL(sql, null);
		if (colDados != null) {
			List fields = new ArrayList();
			fields.add("idCategoriaServico");
			fields.add("idCategoriaServicoPai");
			fields.add("idEmpresa");
			fields.add("nomeCategoriaServico");
			fields.add("dataInicio");
			return this.listConvertion(CategoriaServicoDTO.class, colDados, fields);
		}
		return null;
	}
	
	public Collection findByIdPai(Integer idCategoriaPaiParm) throws PersistenceException {
		String sql = "SELECT idCategoriaServico, idCategoriaServicoPai, idEmpresa, nomeCategoriaServico, DataInicio FROM CATEGORIASERVICO ";
		sql += "WHERE idCategoriaServicoPai = ? AND dataFim IS NULL ";
		sql += String.format("and upper(tipoCategoria) = upper('%s') ", TipoCategoria.CATEGORIA_INCIDENTE_REQUISICAO.getIdentificador());
		sql += "ORDER BY nomeCategoriaServico";
		List colDados = this.execSQL(sql, new Object[] { idCategoriaPaiParm });
		if (colDados != null) {
			List fields = new ArrayList();
			fields.add("idCategoriaServico");
			fields.add("idCategoriaServicoPai");
			fields.add("idEmpresa");
			fields.add("nomeCategoriaServico");
			fields.add("dataInicio");
			return this.listConvertion(CategoriaServicoDTO.class, colDados, fields);
		}
		return null;
	}
	
	/**
	 * Lista os nomes da empresa.
	 *
	 * @param idEmpresa
	 * @return
	 * @throws Exception
	 */
	public Collection listByEmpresa(Integer idEmpresa) throws PersistenceException {
		List list = new ArrayList();
		list.add(new Order("nomeCategoriaServico"));
		CategoriaServicoDTO obj = new CategoriaServicoDTO();
		obj.setIdEmpresa(idEmpresa);
		return super.find(obj, list);
	}

	/**
	 * Retorna lista de Categoria Servio ativas.
	 *
	 * @return Collection
	 * @throws Exception
	 */
	public Collection listCategoriasAtivas() throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();

		condicao.add(new Condition("dataFim", "is", null));
		ordenacao.add(new Order("nomeCategoriaServico"));

		return super.findByCondition(condicao, ordenacao);
	}

	/**
	 * Retorna lista de Categoria Servio setado idPai e idFilho.
	 *
	 * @return Collection
	 * @throws Exception
	 */
	public List<CategoriaServicoDTO> listCategoriasServicoidPaiFilho(CategoriaServicoDTO bean) throws PersistenceException {

		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("nomeCategoriaServico", "=", bean.getNomeCategoriaServico()));
		condicao.add(new Condition("idCategoriaServicoPai", "=", bean.getIdCategoriaServicoPai()));
		return (List<CategoriaServicoDTO>) super.findByCondition(condicao, ordenacao);
	}

	/**
	 * Retorna lista de Categoria Servio setado idCategoria e pai isnull.
	 *
	 * @return Collection
	 * @throws Exception
	 */
	public List<CategoriaServicoDTO> listCategoriasServicoidPaiIsNull(CategoriaServicoDTO bean) throws PersistenceException {

		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("nomeCategoriaServico", "=", bean.getNomeCategoriaServico()));
		condicao.add(new Condition("idCategoriaServicoPai", "is",null ));
		return (List<CategoriaServicoDTO>) super.findByCondition(condicao, ordenacao);
	}



	/**
	 * Retorna lista de Categoria Servio ativas.
	 *
	 * @return Collection
	 * @throws Exception
	 */
	public Collection listCategoriasAtivasByNomeConcatenado() throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();

		condicao.add(new Condition("dataFim", "is", null));
		ordenacao.add(new Order("idCategoriaServico"));

		return super.findByCondition(condicao, ordenacao);
	}

	/**
	 * Verifica se Categoria possui filho.
	 *
	 * @param categoriaServico
	 * @return - <b>True:</b> Possui filho. - <b>False: </b>No possui.
	 * @throws PersistenceException
	 */
	public boolean verificarSeCategoriaPossuiFilho(CategoriaServicoDTO categoriaServico) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List parametros = new ArrayList();

		sql.append("SELECT DISTINCT categoriafilho.nomecategoriaservico FROM categoriaservico categoriapai ");
		sql.append("INNER JOIN categoriaservico categoriafilho ON categoriapai.idcategoriaservico = categoriafilho.idcategoriaservicopai ");
		sql.append("WHERE categoriapai.idcategoriaservico = ? AND categoriafilho.datafim IS NULL");
		parametros.add(categoriaServico.getIdCategoriaServico());

		List filhos = execSQL(sql.toString(), parametros.toArray());

		if (filhos != null && !filhos.isEmpty()) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Verifica se Categoria possui Servio associado
	 *
	 * @param categoriaServico
	 * @return - <b>True:</b> Possui filho. - <b>False: </b>No possui.
	 * @throws PersistenceException
	 */
	public boolean verificarSeCategoriaPossuiServico(CategoriaServicoDTO categoriaServico) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List parametros = new ArrayList();

		sql.append("SELECT DISTINCT servico.nomeservico FROM categoriaservico ");
		sql.append("INNER JOIN servico ON categoriaservico.idcategoriaservico = servico.idcategoriaservico ");
		sql.append("WHERE categoriaservico.idcategoriaservico = ?");
		parametros.add(categoriaServico.getIdCategoriaServico());

		List categoriasEncontradas = execSQL(sql.toString(), parametros.toArray());

		if (categoriasEncontradas != null && !categoriasEncontradas.isEmpty()) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Verifica se categoria informada j existe.
	 *
	 * @param categoriaServicoDTO
	 * @return true - existe; false - no existe;
	 * @throws PersistenceException
	 */
	public boolean verificarSeCategoriaExiste(CategoriaServicoDTO categoriaServicoDTO) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List parametros = new ArrayList();

		sql.append("SELECT nomecategoriaservico FROM categoriaservico ");
		sql.append("WHERE datafim is null AND nomecategoriaservico like ? ");
		parametros.add(categoriaServicoDTO.getNomeCategoriaServico());

		sql.append("and tipocategoria = ? ");
		parametros.add(categoriaServicoDTO.getTipoCategoria());

		List categorias = execSQL(sql.toString(), parametros.toArray());

		if (categorias != null && !categorias.isEmpty()) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Retorna o id da categoria se a categoria informada j existe.
	 *
	 * @param categoriaServicoDTO
	 * @return Integer;
	 * @throws PersistenceException
	 */
	public Integer getIdCategoriaSeExiste(CategoriaServicoDTO categoriaServicoDTO) throws PersistenceException {
		List listResultado = new ArrayList<>();
		StringBuilder sql = new StringBuilder();
		List parametros = new ArrayList();

		sql.append(" SELECT ");
		sql.append(" 	idCategoriaServico");
		sql.append(" FROM ");
		sql.append(" 	categoriaservico ");
		sql.append(" WHERE ");
		sql.append("	datafim IS NULL ");
		sql.append("	AND nomecategoriaservico LIKE ? ");
		sql.append("	AND tipocategoria = ? ");

		parametros.add(categoriaServicoDTO.getNomeCategoriaServico());
		parametros.add(categoriaServicoDTO.getTipoCategoria());


		listResultado = this.execSQL(sql.toString(), parametros.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idCategoriaServico");

		List<CategoriaServicoDTO> listaCategoriaNegocio = (List<CategoriaServicoDTO>) this.engine.listConvertion(getBean(), listResultado, listRetorno);

		if (listaCategoriaNegocio != null && !listaCategoriaNegocio.isEmpty()) {
			CategoriaServicoDTO categoria = listaCategoriaNegocio.iterator().next();
			if (categoria != null) {
				return categoria.getIdCategoriaServico();
			}
		}

		return null;
	}

	/**
	 * Retorna lista de Categoria Servio por nome.
	 *
	 * @return Collection
	 * @throws Exception
	 */
	public Collection findByNomeCategoria(CategoriaServicoDTO categoriaServicoDTO) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();

		condicao.add(new Condition("nomeCategoriaServico", "=", categoriaServicoDTO.getNomeCategoriaServico()));
		ordenacao.add(new Order("nomeCategoriaServico"));

		return super.findByCondition(condicao, ordenacao);
	}


	/**
	 * Encontra a categoria de servio pelo ID
	 *
	 * @author euler.ramos
	 */
	public List<CategoriaServicoDTO> findByIdCategoriaServico(Integer id) throws PersistenceException {
		List resp = new ArrayList();

		Collection fields = getFields();
		List parametro = new ArrayList();
		List listRetorno = new ArrayList();
		String campos = "";
		for (Iterator it = fields.iterator(); it.hasNext();) {
			Field field = (Field) it.next();
			if (!campos.trim().equalsIgnoreCase("")) {
				campos = campos + ",";
			}
			campos = campos + field.getFieldDB();
			listRetorno.add(field.getFieldClass());
		}

		String sql = "SELECT " + campos + " FROM " + getTableName() + " WHERE idcategoriaservico=? and (datafim IS NULL) ORDER BY idcategoriaservico";
		parametro.add(id);
		resp = this.execSQL(sql, parametro.toArray());

		List result = this.engine.listConvertion(getBean(), resp, listRetorno);
		return result == null ? new ArrayList<CategoriaServicoDTO>() : result;
	}

	/**
	 * Encontra a categoria de servio pelo nome
	 *
	 * @author euler.ramos
	 */
	public List<CategoriaServicoDTO> findByNomeCategoria(String titulo) throws PersistenceException {
		List resp = new ArrayList();

		Collection fields = getFields();
		List parametro = new ArrayList();
		List listRetorno = new ArrayList();
		String campos = "";
		for (Iterator it = fields.iterator(); it.hasNext();) {
			Field field = (Field) it.next();
			if (!campos.trim().equalsIgnoreCase("")) {
				campos = campos + ",";
			}
			campos = campos + field.getFieldDB();
			listRetorno.add(field.getFieldClass());
		}

		String sql = "SELECT " + campos + " FROM " + getTableName() + " WHERE nomecategoriaservico=? and (datafim IS NULL) ORDER BY nomecategoriaservico";
		parametro.add(titulo);
		resp = this.execSQL(sql, parametro.toArray());

		List result = this.engine.listConvertion(getBean(), resp, listRetorno);
		return result == null ? new ArrayList<CategoriaServicoDTO>() : result;
	}

	public List<CategoriaServicoDTO> findCategoriaRelacionadaAoServicoContrato(Integer idContrato, Integer idServicoNegocioTecnico) throws PersistenceException {
		StringBuilder sb = new StringBuilder();
		List parametros = new ArrayList();
		
		sb.append("SELECT DISTINCT \n");
		sb.append("	cat.idCategoriaServico, \n");
		sb.append("	cat.nomeCategoriaServico \n");
		sb.append("FROM \n");
		sb.append("	categoriaservico cat \n");
		sb.append("	inner join servico serv on cat.idCategoriaServico = serv.idCategoriaServico \n");
		sb.append("	inner join servicocontrato servcont on serv.idServico = servcont.idServico \n");
		sb.append("	left join servicoautorelacionamento autorel on serv.idServico = autorel.idServico \n");
		sb.append("WHERE \n");
		sb.append("	cat.dataFim is null \n");
		sb.append("	and (upper(serv.deleted) = upper('n') or serv.deleted is null) \n");
		sb.append("	and (upper(servcont.deleted) <> upper('y') or servcont.deleted is null) \n");
		sb.append(String.format("	and (servcont.datafim is null or servcont.datafim > '%s') \n", UtilDatas.getDataAtual()));
		sb.append(String.format("	and servcont.idContrato = %s \n", idContrato));
		sb.append(String.format("	and upper(tipoCategoria) = upper('%s') \n", TipoCategoria.CATEGORIA_INCIDENTE_REQUISICAO.getIdentificador()));

		if (!UtilNumbersAndDecimals.nullToZero(idServicoNegocioTecnico).equals(new Integer(0))) {
			sb.append(String.format("	and autorel.idServicoRelacionado = %s \n", idServicoNegocioTecnico));
			sb.append(String.format("	and (autorel.dataFim is null or autorel.dataFim > '%s') ", UtilDatas.getDataAtual()));
		}
		
		sb.append("	and servcont.idcontrato = ? ");
		parametros.add(idContrato);

		if(idServicoNegocioTecnico != null && idServicoNegocioTecnico >= 0){
			sb.append("	and serv.idservico = ? ");
			parametros.add(idServicoNegocioTecnico);
		}

		List retorno = this.execSQL(sb.toString(), parametros.toArray());

		List<String> camposRetorno = new ArrayList<String>();
		camposRetorno.add("idCategoriaServico");
		camposRetorno.add("nomeCategoriaServico");

		List<CategoriaServicoDTO> result = this.listConvertion(getBean(), retorno, camposRetorno);

		if (result != null) {
			return result;
		}

		return new ArrayList<CategoriaServicoDTO>();
	}
	
	public Collection<CategoriaServicoDTO> listByTipoCategoria(String tipoCategoria) throws Exception {
		List<Condition> condicao = new ArrayList<>();
		List<Order> ordenacao = new ArrayList<>();
		condicao.add(new Condition("tipoCategoria", Condition.EQUALS, tipoCategoria));
		condicao.add(new Condition("dataFim", Condition.IS, null));
		ordenacao.add(new Order("nomeCategoriaServico"));
		return this.findByCondition(condicao, ordenacao);
	}
	
	public Collection<CategoriaServicoDTO> findAutoCompleteCategoriaServico(Integer idContrato, Integer idServicoNegocio, String queryConsulta) throws Exception {

		if(queryConsulta == null) {
			queryConsulta = "";
		}

		queryConsulta = tratarQueryConsulta(queryConsulta);

		List parametros = new ArrayList();
		StringBuilder sql = new StringBuilder();

		sql.append(" select distinct cs.idcategoriaservico, cs.nomecategoriaservico, cs.idcategoriaservicopai from categoriaservico cs ")
		.append(" inner join servico s on s.idcategoriaservico = cs.idcategoriaservico ")
		.append(" inner join servicocontrato sc on sc.idservico = s.idservico ")
		.append(" where  ");
		
		if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.POSTGRESQL)) {
			sql.append("	(UPPER(remove_acento(cs.nomecategoriaservico)) ilike UPPER(remove_acento(?))) ");
		} else {
			sql.append("	UPPER(cs.nomecategoriaservico) like UPPER(?) ");
		}
		parametros.add(queryConsulta);

		sql.append("	and sc.idcontrato = ? ");
		parametros.add(idContrato);

		if(idServicoNegocio != null && idServicoNegocio >= 0){
			sql.append("	and s.idservico = ? ");
			parametros.add(idServicoNegocio);
		}

		sql.append(" ORDER BY ");
		sql.append("	cs.nomecategoriaservico");

		List lista = this.execSQL(sql.toString(), parametros.toArray());

		List<String> listaRetorno = new ArrayList();
		listaRetorno.add("idCategoriaServico");
		listaRetorno.add("nomeCategoriaServico");
		listaRetorno.add("idCategoriaServicoPai");

		return this.listConvertion(CategoriaServicoDTO.class, lista, listaRetorno);
	}
}