package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ComplexidadeDTO;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

/**
 * @author ibimon.morais 21/09/2015
 */
@SuppressWarnings({ "unchecked", "rawtypes" })
public class ComplexidadeDao extends CrudDaoDefaultImpl {

	public ComplexidadeDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		final Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idcontrato", "idContrato", true, false, false, false));
		listFields.add(new Field("complexidade", "complexidade", true, false, false, false));
		listFields.add(new Field("valorcomplexidade", "valorComplexidade", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return this.getOwner() + "Complexidade";
	}

	@Override
	public Class getBean() {
		return ComplexidadeDTO.class;
	}
		
	public List<ComplexidadeDTO> consultarPorIdContrato(final Integer idContrato)throws Exception{
		List<Condition> condicao = new ArrayList<Condition>(0);
		List<Order> ordenacao = new ArrayList<Order>(0);
		
		condicao.add(new Condition("idContrato", "=", idContrato));
		ordenacao.add(new Order("complexidade"));
		return (List<ComplexidadeDTO>) super.findByCondition(condicao, ordenacao);	
	}
}
