package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ConhecimentoMidiaSoftwareDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class ConhecimentoMidiaSoftwareDAO extends CrudDaoDefaultImpl {


	public ConhecimentoMidiaSoftwareDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection find(IDto obj) throws PersistenceException {

		return null;
	}

	@Override
	public Collection<Field> getFields() {

		Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idconhecimentomidiasoftware", "idConhecimentoMidiaSoftware", true, true, false, false));
		listFields.add(new Field("idmidiasoftware", "idMidiaSoftware", false, false, false, false));
		listFields.add(new Field("idbaseconhecimento", "idBaseConhecimento", false, false, false, false));
		listFields.add(new Field("datafim", "dataFim", false, false, false, false));

		return listFields;
		
	}

	@Override
	public String getTableName() {
		return "conhecimentomidiasoftware";
	}

	@Override
	public Class getBean() {
		return ConhecimentoMidiaSoftwareDTO.class;
	}

	@Override
	public Collection list() throws PersistenceException {
		return null;
	}

	public void deleteByIdConhecimentoMidiaSoftware(Integer idConhecimentoMidiaSoftware) throws PersistenceException {
		List parametros = new ArrayList();
		if (idConhecimentoMidiaSoftware != null) {
			parametros.add(UtilDatas.getDataAtual());
			parametros.add(idConhecimentoMidiaSoftware);
			
			String sql = "UPDATE " + getTableName() + " SET datafim = ? WHERE idconhecimentomidiasoftware = ?";
			execUpdate(sql, parametros.toArray());
		}
	}
	
	public void deleteByIdMidiaSoftware(Integer idMidiaSoftware) throws PersistenceException {
		List parametros = new ArrayList();
		if (idMidiaSoftware != null) {
			parametros.add(UtilDatas.getDataAtual());
			parametros.add(idMidiaSoftware);
			String sql = "UPDATE " + getTableName() + " SET datafim = ? WHERE idmidiasoftware = ?";
			execUpdate(sql, parametros.toArray());
		}
	}

	public void deleteByIdBaseConhecimento(Integer idBaseConhecimento) throws PersistenceException {
		List parametros = new ArrayList();
		if (idBaseConhecimento != null) {
			parametros.add(UtilDatas.getDataAtual());
			parametros.add(idBaseConhecimento);
			String sql = "UPDATE " + getTableName() + " SET datafim = ? WHERE idBaseConhecimento = ?";
			execUpdate(sql, parametros.toArray());
		}
	}

	public Collection findByIdBaseConhecimento(Integer idBaseConhecimento) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idBaseConhecimento", "=", idBaseConhecimento));
		condicao.add(new Condition("dataFim", Condition.IS, null));
		return super.findByCondition(condicao, ordenacao);
	}

	public Collection<ConhecimentoMidiaSoftwareDTO> findByIdMidiaSoftware(Integer idMidiaSoftware) {
        List result;
        try {
            List resp = new ArrayList();
            List parametro = new ArrayList();
            List listRetorno = new ArrayList();

            listRetorno.add("idConhecimentoMidiaSoftware");
            listRetorno.add("idMidiaSoftware");
            listRetorno.add("idBaseConhecimento");
			listRetorno.add("titulo");
			listRetorno.add("dataFim");
			
            StringBuilder sql = new StringBuilder();
            sql.append("select c.idconhecimentomidiasoftware, c.idmidiasoftware, c.idbaseconhecimento, b.titulo, c.datafim ");
            sql.append("from conhecimentomidiasoftware c join historicobaseconhecimento b on c.idmidiasoftware = ? and ");
            															sql.append("c.idbaseconhecimento = b.idbaseconhecimento and (c.datafim is null) and (b.datafim is null)");
            
			parametro.add(idMidiaSoftware);
            
			resp = this.execSQL(sql.toString(), parametro.toArray());

            result = engine.listConvertion(getBean(), resp, listRetorno);
        } catch (PersistenceException e) {
            e.printStackTrace();
            result = null;
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return (((result == null)||(result.size()<=0)) ? new ArrayList<ConhecimentoMidiaSoftwareDTO>() : result);
	}

}