package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ConscientizacaoDTO;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class ConscientizacaoDAO extends CrudDaoDefaultImpl {

	public ConscientizacaoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "conscientizacao";
	}

	@Override
	public Collection<Field> getFields() {
		final Collection<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("idConscientizacao", "idConscientizacao", true, true, false, false));
		listFields.add(new Field("idContinuidade", "idContinuidadeConscientizacao", false, false, false, false));
		listFields.add(new Field("sumarioExecutivo", "sumarioExecutivoConscientizacao", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<ConscientizacaoDTO> getBean() {
		return ConscientizacaoDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.03.2016
	 */
	@SuppressWarnings("unchecked")
	public ConscientizacaoDTO findConscientizacaoByIdContinuidade(final Integer idContinuidade) throws Exception {
		List<Condition> listCondition = new ArrayList<Condition>();
		listCondition.add(new Condition("idContinuidadeConscientizacao", idContinuidade));
		Collection<ConscientizacaoDTO> listConscientizacao = super.findByCondition(listCondition, null);
		if (listConscientizacao != null && !listConscientizacao.isEmpty()) {
			return listConscientizacao.iterator().next();
		}

		return null;
	}
}
