package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.ConscientizacaoRegistroDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class ConscientizacaoRegistroDAO extends CrudDaoDefaultImpl {

	public ConscientizacaoRegistroDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "conscientizacaoRegistro";
	}

	@Override
	public Collection<Field> getFields() {
		final Collection<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("idConscientizacaoRegistro", "idConscientizacaoRegistro", true, true, false, false));
		listFields.add(new Field("idConscientizacao", "idConscientizacao", false, false, false, false));
		listFields.add(new Field("analiseCriticaAcao", "analiseCriticaAcao", false, false, false, false));
		listFields.add(new Field("tipoAtividade", "tipoAtividade", false, false, false, false));
		listFields.add(new Field("status", "status", false, false, false, false));
		listFields.add(new Field("dataFim", "dataFim", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<ConscientizacaoRegistroDTO> getBean() {
		return ConscientizacaoRegistroDTO.class;
	}

	public void updateNotNull(ConscientizacaoRegistroDTO conscientizacaoRegistroDTO) throws PersistenceException {
		super.updateNotNull(conscientizacaoRegistroDTO);
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.03.2016
	 */
	@SuppressWarnings("unchecked")
	public Collection<ConscientizacaoRegistroDTO> findConscientizacaoRegistrosByIdConscientizacao(final Integer idConscientizacao) throws Exception {
		List<Condition> listCondition = new ArrayList<Condition>();
		listCondition.add(new Condition("idConscientizacao", idConscientizacao));
		listCondition.add(Condition.AND, new Condition("dataFim", Condition.IS, null));
		Collection<ConscientizacaoRegistroDTO> listConscientizacaoRegistro = super.findByCondition(listCondition, null);

		if (listConscientizacaoRegistro != null && !listConscientizacaoRegistro.isEmpty()) {
			return listConscientizacaoRegistro;
		}

		return Collections.emptyList();
	}
	
	/**
	 * @author deborah.ferreira
	 * @since 08.03.2016
	 */
	public void deleteConscientizacaoRegistroByIdConscientizacao(final Integer idConscientizacao) throws Exception {
		List<Condition> listCondition = new ArrayList<Condition>();
		listCondition.add(new Condition("idConscientizacao", idConscientizacao));
		super.deleteByCondition(listCondition);
	}

	/**
	 * @author deborah.ferreira
	 * @since 08.03.2016
	 */
	public void deleteConscientizacaoRegistroById(final Integer idConscientizacaoRegistro) throws Exception {
		List<Condition> listCondition = new ArrayList<Condition>();
		listCondition.add(new Condition("idConscientizacaoRegistro", idConscientizacaoRegistro));
		super.deleteByCondition(listCondition);
	}
}
