package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ContratoFormulaOsDTO;
import br.com.centralit.citcorpore.util.Util;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

/**
 * @author ibimon.morais
 * @29/09/2015
 */
@SuppressWarnings({ "unchecked", "rawtypes" })
public class ContratoFormulaOsDao extends CrudDaoDefaultImpl {

	public ContratoFormulaOsDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	/**
	 * @author ibimon.morais
	 */
	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idcontratoformulaos", "idContratoFormulaOs", true, true, false, false));
		listFields.add(new Field("idContrato", "idContrato", false, false, false, false));
		listFields.add(new Field("idformulaos", "idFormulaOs", false, false, false, false));
		listFields.add(new Field("deleted", "deleted", false, false, false, false));
		return listFields;

	}

	/**
	 * @author ibimon.morais
	 */
	@Override
	public String getTableName() {
		return "contratoformulaos";
	}

	/**
	 * @author ibimon.morais
	 */
	@Override
	public Class getBean() {
		return ContratoFormulaOsDTO.class;
	}
	
	/**
	 * br.com.centralit.citcorpore.integracao.ContratoFormulaOsDao.java_(findByIdContratoIdFormula)
	 * @29/09/2015
	 * @author ibimon.morais
	 */
	public ContratoFormulaOsDTO findByIdContratoIdFormula(final Integer idContrato, final Integer idFormula) throws PersistenceException {
		List<Condition> condicao = new ArrayList<>();
		List<Order> ordenacao = new ArrayList<>();
		condicao.add(new Condition("idContrato", "=", idContrato));
		condicao.add(new Condition("idFormulaOs", "=", idFormula));
		List<ContratoFormulaOsDTO> retorno = (List<ContratoFormulaOsDTO>) super.findByCondition(condicao, ordenacao);
		return !Util.isNullOrEmpty(retorno) ? retorno.get(0) : null;
	}
	
	/**
	 * br.com.centralit.citcorpore.integracao.ContratoFormulaOsDao.java_(findByIdContrato)
	 * @29/09/2015
	 * @author ibimon.morais
	 */
	public Collection<ContratoFormulaOsDTO> findByIdContrato(final Integer idContrato) throws PersistenceException {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();
		condicao.add(new Condition("idContrato", "=", idContrato));
		condicao.add(new Condition("deleted", "!=", "Y"));
		ordenacao.add(new Order("idFormulaOs"));
		return super.findByCondition(condicao, ordenacao);
	}

	/**
	 * @author ibimon.morais
	 */
	@Override
	public Collection list() throws PersistenceException {
		return null;
	}

}
