package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ContratoPerfilDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;
/**
 * @author ibimon.morais
 * @23/09/2015
 */
public class ContratoPerfilDao extends CrudDaoDefaultImpl {

    public ContratoPerfilDao() {
        super(Constantes.getValue("DATABASE_ALIAS"), null);
    }

    @Override
    public Collection<ContratoPerfilDTO> find(final IDto arg0) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Field> getFields() {
    	final Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idperfilcontrato", "idPerfilContrato", true, true, false, false));
		listFields.add(new Field("idcontrato", "idContrato", false, false, false, false));
		listFields.add(new Field("nomeperfilcontrato", "nomePerfilContrato", false, false, false, false));
		listFields.add(new Field("custohora", "custoHora", false, false, false, false));
		listFields.add(new Field("deleted", "deleted", false, false, false, false));
        return listFields;
    }

    @Override
    public String getTableName() {
    	return "perfilcontrato";
    }

    @Override
    public Collection<ContratoPerfilDTO> list() throws PersistenceException {
        return null;
    }

    @Override
    public Class<ContratoPerfilDTO> getBean() {
        return ContratoPerfilDTO.class;
    }

    @SuppressWarnings("unchecked")
	public Collection<ContratoPerfilDTO> findByIdContrato(final Integer idContrato) throws Exception {
    	List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("idContrato", "=", idContrato));
		ordenacao.add(new Order("idPerfilContrato"));
		return super.findByCondition(condicao, ordenacao);
	}

	public void deleteByIdContrato(final Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idContrato", "=", parm));
		super.deleteByCondition(condicao);
	}
}
