package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.ContratosGruposDTO;
import br.com.centralit.citcorpore.bean.ContratosUnidadesDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class ContratosUnidadesDAO extends CrudDaoDefaultImpl {

	public ContratosUnidadesDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<ContratosUnidadesDTO> find(final IDto obj) throws PersistenceException {
		return null;
	}

	@Override
	public Collection<Field> getFields() {
		final Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idUnidade", "idUnidade", true, false, false, false));
		listFields.add(new Field("idContrato", "idContrato", true, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return "contratosunidades";
	}

	@Override
	public Collection<ContratosUnidadesDTO> list() throws PersistenceException {
		return null;
	}

	public void deleteByIdUnidade(final Integer idUnidade) throws PersistenceException {
		final List<Condition> condicao = new ArrayList<>();
		condicao.add(new Condition("idUnidade", "=", idUnidade));
		super.deleteByCondition(condicao);
	}

	@Override
	public Class<ContratosUnidadesDTO> getBean() {
		return ContratosUnidadesDTO.class;
	}

	@SuppressWarnings("unchecked")
	public Collection<ContratosUnidadesDTO> findByIdUnidade(final Integer idUnidade) throws PersistenceException {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();
		ordenacao.add(new Order("idContrato"));
		condicao.add(new Condition("idUnidade", "=", idUnidade));
		return super.findByCondition(condicao, ordenacao);
	}
	
	public void deleteByIdContratoAndIdUnidade(final Integer idContrato, final Integer idUnidade) throws PersistenceException {
		ArrayList<Integer> parametros = new ArrayList<Integer>();
		StringBuilder sql = new StringBuilder();
		sql.append("DELETE FROM contratosunidades WHERE contratosunidades.idunidade = ? and contratosunidades.idcontrato = ?;");
		parametros.add(idUnidade);
		parametros.add(idContrato);
		this.execUpdate(sql.toString(), parametros.toArray());
	}	

	/**
	 * 
	 * projeto-missao_novo_paradigma - ContratosUnidadesDAO.java_(#isContratosUnidadeExiste).
	 *
	 * @since 12/11/2015
	 * @author ibimon.morais
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public boolean isContratosUnidadeExiste(final ContratosUnidadesDTO unidadeDTO, final ContratoDTO contrato) throws PersistenceException {
		List<ContratosUnidadesDTO> result = null;
		final StringBuilder sql = new StringBuilder();
		final ArrayList<Integer> parametros = new ArrayList<Integer>();

		sql.append("SELECT distinct idcontrato ");
		sql.append("FROM contratosunidades ");
		sql.append("WHERE contratosunidades.idunidade = ? and idcontrato = ?");
		parametros.add(unidadeDTO.getIdUnidade());
		parametros.add(contrato.getIdContrato());

		final List<ContratosUnidadesDTO> listaConsultada = this.execSQL(sql.toString(), parametros.toArray());
		final List listRetorno = new ArrayList();
		listRetorno.add("idUnidade");
		result = this.engine.listConvertion(ContratosGruposDTO.class, listaConsultada, listRetorno);

		if (result != null && !result.isEmpty()) {
			return Boolean.TRUE;
		}

		return Boolean.FALSE;
	}
	
	@SuppressWarnings("unchecked")
	public Collection<ContratosUnidadesDTO> findByIdContrato(Integer idContrato) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();

		condicao.add(new Condition("idContrato", "=", idContrato));
		ordenacao.add(new Order("idUnidade"));

		return super.findByCondition(condicao, ordenacao);
	}

}
