package br.com.centralit.citcorpore.integracao;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ControleSlaDTO;
import br.com.centralit.citcorpore.bean.result.QuantidadeResultDTO;
import br.com.centralit.citcorpore.util.Enumerados.ControleSLA;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilNumbersAndDecimals;

/**
 * @author gilberto.nery
 * @date 2016-13-09
 */
@SuppressWarnings("unchecked")
public class ControleSlaDao extends CrudDaoDefaultImpl {
	public ControleSlaDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idcontrolesla" ,"idControleSla", true, true, false, false));
		listFields.add(new Field("idsolicitacaoservico" ,"idSolicitacaoServico", false, false, false, false));
		listFields.add(new Field("idstatusinicial", "idStatusInicial", false, false, false, false));
		listFields.add(new Field("idstatusfinal", "idStatusFinal", false, false, false, false));
		listFields.add(new Field("datainicial" ,"dataInicial", false, false, false, false));
		listFields.add(new Field("datafinal" ,"dataFinal", false, false, false, false));
		listFields.add(new Field("idusuario" ,"idUsuario", false, false, false, false));
		listFields.add(new Field("idtarefa" ,"idTarefa", false, false, false, false));
		//Tempo total segundos
		listFields.add(new Field("tempototal", "tempoTotal", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return this.getOwner() + "ControleSla";
	}

	@Override
	public Collection<ControleSlaDTO> list() throws PersistenceException {
		return super.list();
	}

	@Override
	public Class<ControleSlaDTO> getBean() {
		return ControleSlaDTO.class;
	}

	@Override
	public Collection<ControleSlaDTO> find(IDto arg0) throws PersistenceException {
		if(arg0 instanceof ControleSlaDTO){
			List<Condition> condicao = new ArrayList<Condition>();
			List<Order> ordenacao = new ArrayList<Order>();
			condicao.add(new Condition("idControleSla", ((ControleSlaDTO) arg0).getIdControleSla()));
			ordenacao.add(new Order("idControleSla"));
			return super.findByCondition(condicao, ordenacao);
		}

		return null;
	}

	/**
	 * Restaura a o controle Sla pelo id da solicitacao de servico
	 *
	 * @param idSolicitacaoServico
	 * @return
	 * @throws PersistenceException
	 */
	public Collection<ControleSlaDTO> findByIdSolicitacaoServico(Integer idSolicitacaoServico) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("idSolicitacaoServico", idSolicitacaoServico));
		ordenacao.add(new Order("idControleSla"));

		return super.findByCondition(condicao, ordenacao);
	}


	/**
	 * Restaura a o controle Sla pelo id da solicitacao de servico
	 *
	 * @param idSolicitacaoServico
	 * @param ordem
	 * @return
	 * @throws PersistenceException
	 */
	public Collection<ControleSlaDTO> findByIdSolicitacaoServicoAndContabilizaSla(Integer idSolicitacaoServico) throws PersistenceException {

		final List<Integer> parametro = new ArrayList<Integer>();
		final List<String> listRetorno = new ArrayList<String>();

		StringBuilder sql = new StringBuilder();

		sql.append("select idcontrolesla,idsolicitacaoservico,idstatusinicial,idstatusfinal,datainicial,datafinal,idusuario,idtarefa,tempototal \n");
		sql.append(" from controlesla sla \n");
		sql.append(" inner join bpm_itemtrabalhofluxo it on sla.idtarefa = it.iditemtrabalho \n");
		sql.append(" inner join bpm_elementofluxo ef on it.idelemento = ef.idelemento \n");
		sql.append(" where ");
		sql.append(" sla.idstatusinicial != ").append(ControleSLA.SUSPENSO.getId()).append(" \n");
		sql.append(" and upper(ef.contabilizasla) != upper('").append(SimNao.NAO.getValorStr()).append("') \n");
		sql.append(" and sla.idsolicitacaoservico = ? ");

		parametro.add(idSolicitacaoServico);

		sql.append(" order by idControleSla desc");

		listRetorno.add("idControleSla");
		listRetorno.add("idSolicitacaoServico");
		listRetorno.add("idStatusInicial");
		listRetorno.add("idStatusFinal");
		listRetorno.add("dataInicial");
		listRetorno.add("dataFinal");
		listRetorno.add("idUsuario");
		listRetorno.add("idTarefa");
		listRetorno.add("tempoTotal");

		try {
			List<Object> list = this.execSQL(sql.toString(), parametro.toArray());
			return this.listConvertion(this.getBean(), list, listRetorno);
		}catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}


	/**
	 * Consulta o ultimo registro de ControleSla da solicitacao de servico
	 *
	 * @param idSolicitacaoServico
	 * @param idTarefa
	 * @return
	 */
	public ControleSlaDTO consultarUltimoRegistroDeSlaDaSolicitacaoDeServico(Integer idSolicitacaoServico, Integer idTarefa) {

		final List<Integer> parametro = new ArrayList<Integer>();
		final List<String> listRetorno = new ArrayList<String>();
		List<Object> list = new ArrayList<Object>();

		StringBuilder sql = new StringBuilder();
		sql.append("select idSolicitacaoServico, idControleSla, idStatusInicial, idStatusFinal, ");
		sql.append(" dataInicial, dataFinal, idUsuario, idTarefa, tempoTotal from ControleSla ");
		sql.append(" where idsolicitacaoservico = ?");
		parametro.add(idSolicitacaoServico);
		sql.append(" and idTarefa = ?");
		parametro.add(idTarefa);

		sql.append(" order by idControleSla desc");

		listRetorno.add("idSolicitacaoServico");
		listRetorno.add("idControleSla");
		listRetorno.add("idStatusInicial");
		listRetorno.add("idStatusFinal");
		listRetorno.add("dataInicial");
		listRetorno.add("dataFinal");
		listRetorno.add("idUsuario");
		listRetorno.add("idTarefa");
		listRetorno.add("tempoTotal");

		try {

			list = this.execSQL(sql.toString(), parametro.toArray());

			if (list != null && !list.isEmpty()) {
				return (ControleSlaDTO) this.listConvertion(this.getBean(), list, listRetorno).get(0);
			} else {
				return null;
			}
		} catch (PersistenceException e) {
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * Consulta todos os registros abertos de Controle de Sla por solicitao de servio.
	 *
	 * @param idSolicitacaoServico
	 * @param idTarefa
	 * @return
	 */
	public List<ControleSlaDTO> consultaRegistrosAbertosControleSla(Integer idSolicitacaoServico) {
		final List<Integer> parametro = new ArrayList<Integer>();
		final List<String> listRetorno = new ArrayList<String>();
		List<Object> list = new ArrayList<Object>();

		StringBuilder sql = new StringBuilder();
		sql.append("select idSolicitacaoServico, idControleSla, idStatusInicial, idStatusFinal, ");
		sql.append(" dataInicial, dataFinal, idUsuario, idTarefa, tempoTotal from ControleSla ");
		sql.append(" where datafinal is null and idsolicitacaoservico = ?");
		parametro.add(idSolicitacaoServico);

		sql.append(" order by idControleSla desc");

		listRetorno.add("idSolicitacaoServico");
		listRetorno.add("idControleSla");
		listRetorno.add("idStatusInicial");
		listRetorno.add("idStatusFinal");
		listRetorno.add("dataInicial");
		listRetorno.add("dataFinal");
		listRetorno.add("idUsuario");
		listRetorno.add("idTarefa");
		listRetorno.add("tempoTotal");

		try {

			list = this.execSQL(sql.toString(), parametro.toArray());

			if (list != null && !list.isEmpty()) {
				return this.listConvertion(this.getBean(), list, listRetorno);
			} else {
				return null;
			}
		} catch (PersistenceException e) {
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * <pre>
	 * Encontra todos os registros de Controle de Sla e realiza a soma da coluna <code>tempototal</code>.
	 * Condies:
	 * - O status inicial deve ser diferente de {@link ControleSLA#SUSPENSO};
	 * - Pela instncia do fluxo, identificar que o elemento de fluxo deve contabilizar SLA;
	 *
	 * Aps isso, realiza a soma dos valores.
	 * </pre>
	 *
	 * @author douglas.japiassu
	 * @since 22.09.2016
	 */
	public Double somarRegistrosDeSlaDaSolicitacaoDeServico(Integer idSolicitacaoServico, Timestamp dataHoraInicioSLA) {
		Double somaTempoTotal = 0d;
		if (UtilNumbersAndDecimals.isNullOrZeroOrEmpty(idSolicitacaoServico)) {
			return somaTempoTotal;
		}

		final List<Object> parametro = new ArrayList<Object>();
		List<Object> list = new ArrayList<Object>();

		StringBuilder sql = new StringBuilder();

		sql.append("select \n")
			.append("	sum(tempototal) \n")
			.append("from \n")
			.append("	controlesla sla \n")
			.append("	inner join bpm_itemtrabalhofluxo it on sla.idtarefa = it.iditemtrabalho \n")
			.append("	inner join bpm_elementofluxo ef on it.idelemento = ef.idelemento \n")
			.append("where \n")
			.append("	sla.idsolicitacaoservico = ? and \n");
		parametro.add(idSolicitacaoServico);
		if (dataHoraInicioSLA!=null){
			sql.append("	sla.datainicial >= ? and \n");
			parametro.add(dataHoraInicioSLA);
		}
		sql.append("	sla.idstatusinicial != ").append(ControleSLA.SUSPENSO.getId()).append(" and \n")
			.append("	upper(ef.contabilizasla) != upper('").append(SimNao.NAO.getValorStr()).append("')\n");

		try {

			list = this.execSQL(sql.toString(), parametro.toArray());

			ArrayList<String> fields = new ArrayList<String>();
			fields.add("quantidade");

			list = this.listConvertion(QuantidadeResultDTO.class, list, fields);

			if (list != null && !list.isEmpty()) {
				QuantidadeResultDTO result = (QuantidadeResultDTO) list.iterator().next();

				if (result != null && result.getQuantidade() != null) {
					somaTempoTotal = result.getQuantidade().doubleValue();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		return somaTempoTotal;
	}

	/**
	 * <pre>
	 * Retorna o tempo de suspenso da solicitao de servio, somado ao das tarefas que no contabilizam SLA, seguindo o calendrio e apartir do 
	 * momento que se iniciou a contagem do SLA.
	 * </pre>
	 *
	 * @author euler.ramos
	 * @since 18.11.2016
	 */
	public Double obtenTempoSlaNaoContabilizado(Integer idSolicitacaoServico, Timestamp dataHoraInicioSLA) {
		Double somaTempoSuspensao = 0d;
		if (UtilNumbersAndDecimals.isNullOrZeroOrEmpty(idSolicitacaoServico)) {
			return somaTempoSuspensao;
		}

		final List<Object> parametro = new ArrayList<Object>();
		List<Object> list = new ArrayList<Object>();

		StringBuilder sql = new StringBuilder();

		sql.append("select case when tempoForaSLA is null then 0 else tempoForaSLA end tempoForaSLA ")
			.append("from (")
				.append("select sum(tempototal) tempoForaSLA ")
				.append("from controlesla sla ")
					.append("inner join bpm_itemtrabalhofluxo it on sla.idtarefa = it.iditemtrabalho ")
					.append("inner join bpm_elementofluxo ef on it.idelemento = ef.idelemento ")
				.append("where sla.idsolicitacaoservico = ? ");
		parametro.add(idSolicitacaoServico);
		if (dataHoraInicioSLA!=null){
				sql.append("and sla.datainicial >= ? ");
			parametro.add(dataHoraInicioSLA);
		}
				sql.append("and ((sla.idstatusinicial = ").append(ControleSLA.SUSPENSO.getId()).append(") ")
					.append("or ((ef.contabilizasla is null) or (upper(ef.contabilizasla) != upper('").append(SimNao.SIM.getValorStr()).append("'))))")
			.append(") ts");
		
		try {

			list = this.execSQL(sql.toString(), parametro.toArray());

			ArrayList<String> fields = new ArrayList<String>();
			fields.add("quantidade");

			list = this.listConvertion(QuantidadeResultDTO.class, list, fields);

			if (list != null && !list.isEmpty()) {
				QuantidadeResultDTO result = (QuantidadeResultDTO) list.iterator().next();

				if (result != null && result.getQuantidade() != null) {
					somaTempoSuspensao = result.getQuantidade().doubleValue();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		return somaTempoSuspensao;
	}
	
	@Override
	public IDto create(IDto obj) throws PersistenceException {
		return super.create(obj);
	}
}