package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.DestinatarioEmpregadoDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

@SuppressWarnings({ "unchecked", "rawtypes" })
public class DestinatarioEmpregadoDAO extends CrudDaoDefaultImpl{
	
	public DestinatarioEmpregadoDAO(){
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "destinatarioempregados";
	}

	@Override
	public Collection<Field> getFields() {
		final Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idconfigdestinatario", "idConfigDestinatario", true, false, false, false));
		listFields.add(new Field("idempregado", "idEmpregado", true, false, false, false));
		return listFields;
	}

	@Override
	public Class<DestinatarioEmpregadoDTO> getBean() {
		return DestinatarioEmpregadoDTO.class;
	}
	
	public Collection<DestinatarioEmpregadoDTO> listEmpregadosByIdConfigDestinatario(Long idConfigDestinatario) {
		Collection<DestinatarioEmpregadoDTO> listEmpregados = new ArrayList<DestinatarioEmpregadoDTO>();

		try {
			List retorno = new ArrayList();

			final List fields = new ArrayList();
			fields.addAll(this.getFields());

			StringBuilder sql = new StringBuilder();
			sql.append("select idconfigdestinatario, idempregado from destinatarioempregados ");
			sql.append("where idconfigdestinatario = ?");

			final List params = new ArrayList();
			if (idConfigDestinatario != null && !idConfigDestinatario.toString().isEmpty()
					&& idConfigDestinatario > 0) {
				params.add(idConfigDestinatario);
			} else {
				params.add(0);
			}

			retorno = this.execSQL(sql.toString(), params.toArray());
			listEmpregados = engine.listConvertion(DestinatarioEmpregadoDTO.class, retorno, fields);

		} catch (PersistenceException e) {
			e.printStackTrace();
		}

		if (listEmpregados != null && !listEmpregados.isEmpty() && listEmpregados.size() > 0) {
			return listEmpregados;
		} else {
			return new ArrayList<DestinatarioEmpregadoDTO>();
		}
	}

	public void delete(Long idConfigDestinatario) throws PersistenceException {
		final List<Condition> condicao = new ArrayList<>();
		condicao.add(new Condition("idConfigDestinatario", "=", idConfigDestinatario));

		super.deleteByCondition(condicao);
	}
	
    /**
	 * @author euler.ramos
	 * @since 11.02.2016
	 * @param idConfigDestinatario
	 * @return Collection<EmpregadoDTO>
	 */
	public ArrayList<EmpregadoDTO> listaEmpregadosByIdConfigDestinatario(final Long idConfigDestinatario) {
    	ArrayList<EmpregadoDTO> result;
    	
    	final List listRetorno = new ArrayList<String>();
    	listRetorno.add("idEmpregado");
    	listRetorno.add("nome");
    	listRetorno.add("cpf");
    	listRetorno.add("email");
    	listRetorno.add("telefone");
    	
    	final List parametro = new ArrayList();
		parametro.add(idConfigDestinatario);

        final StringBuilder sql = new StringBuilder();
        sql.append("select em.idempregado,em.nome,em.cpf,em.email,em.telefone ");
		sql.append("from empregados em join destinatarioempregados destemp on destemp.idconfigdestinatario =? and destemp.idempregado = em.idempregado and (em.datafim is null)");
        
        try {
        	List resp = new ArrayList<Object>();
        	resp = this.execSQL(sql.toString(), parametro.toArray());
        	result = (ArrayList<EmpregadoDTO>) engine.listConvertion(EmpregadoDTO.class, resp, listRetorno);
        } catch (final PersistenceException e) {
        	e.printStackTrace();
        	result = null;
        } catch (final Exception e) {
        	e.printStackTrace();
        	result = null;
        }
        return result == null || result.size() <= 0 ? new ArrayList<EmpregadoDTO>() : result;
    }
}