package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.DonoNegocioDTO;
import br.com.centralit.citcorpore.util.Util;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

@SuppressWarnings("unchecked")
public class DonoNegocioDAO extends CrudDaoDefaultImpl{

	public DonoNegocioDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "servicodononegocio";
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		
		listFields.add(new Field("idservicodononegocio", "idServicoDonoNegocio", true, true, false, false));
		listFields.add(new Field("idservico", "idServico", false, false, false, false));
		listFields.add(new Field("idgrupo", "idGrupo", false, false, false, false));
		listFields.add(new Field("idempregado", "idEmpregado", false, false, false, false));
		listFields.add(new Field("tipodononegocio", "tipoDonoNegocio", false, false, false, false));
			
		return listFields;
	}

	@Override
	public Class<DonoNegocioDTO> getBean() {
		return DonoNegocioDTO.class;
	}

	public Collection<DonoNegocioDTO> listByServico(Integer idServico) throws PersistenceException{
		List<Condition> condicao = new ArrayList<>();		
		condicao.add(new Condition("idServico", "=", idServico));	
		return super.findByCondition(condicao, null);
	}
	
	@Override
	public void updateNotNull(IDto obj) throws PersistenceException {
		super.updateNotNull(obj);
	}
	
	public DonoNegocioDTO findServicoDonoNegocioVinculado(Integer idServico, Integer idServicoDonoNegocio) throws Exception {
		List<Condition> condicao = new ArrayList<>();
		List<Order> ordenacao = new ArrayList<>();
		
		condicao.add(new Condition("idServico", idServico));
		condicao.add(new Condition("idServicoDonoNegocio", idServicoDonoNegocio));
		
		List<DonoNegocioDTO> donoNegocio = (List<DonoNegocioDTO>) this.findByCondition(condicao, ordenacao);
		
		if(donoNegocio == null || donoNegocio.isEmpty()){
			return null;
		}
		return donoNegocio.get(0);
	}
	
	
	//Filtro
	public Collection<DonoNegocioDTO> listByServicoAndText(Integer idServicoAtual, String text) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();

		List<DonoNegocioDTO> result = new ArrayList<>();
		List<String> listFieldClassParaPopular = new ArrayList<>();
		Collection<DonoNegocioDTO> listaVinculo;

		listFieldClassParaPopular.add("idServicoDonoNegocio");
		listFieldClassParaPopular.add("idServico");
		listFieldClassParaPopular.add("idEmpregado");
		listFieldClassParaPopular.add("tipoDonoNegocio");

		parametros.add(idServicoAtual);

		sql.append("SELECT DN.IDSERVICODONONEGOCIO, DN.IDSERVICO, DN.IDEMPREGADO, DN.TIPODONONEGOCIO  ");
		sql.append("FROM SERVICODONONEGOCIO DN INNER JOIN EMPREGADOS E ON DN.IDEMPREGADO = E.IDEMPREGADO ");
		sql.append("WHERE IDSERVICO = ? AND ").append(Util.getQueryLikeWithCaseInsensitiveAndAccentInsensitive(MAIN_SGBD, "E.NOME", text));

		result = this.execSQL(sql.toString(), parametros.toArray());
		listaVinculo = this.engine.listConvertion(getBean(), result, listFieldClassParaPopular);

		listFieldClassParaPopular.clear();
		listFieldClassParaPopular.add("idServicoDonoNegocio");
		listFieldClassParaPopular.add("idServico");
		listFieldClassParaPopular.add("idGrupo");
		listFieldClassParaPopular.add("tipoDonoNegocio");

		sql.delete(0, sql.length());
		sql.append("SELECT DN.IDSERVICODONONEGOCIO, DN.IDSERVICO, DN.IDGRUPO, DN.TIPODONONEGOCIO ");
		sql.append("FROM SERVICODONONEGOCIO DN INNER JOIN GRUPO G ON DN.IDGRUPO = G.IDGRUPO ");
		sql.append("WHERE IDSERVICO = ? AND ").append(Util.getQueryLikeWithCaseInsensitiveAndAccentInsensitive(MAIN_SGBD, "G.NOME", text));

		result = this.execSQL(sql.toString(), parametros.toArray());
		listaVinculo.addAll(this.engine.listConvertion(getBean(), result, listFieldClassParaPopular));

		return listaVinculo;

	}
}
