package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.EsquemaDadosDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

/**
 * @author douglas.japiassu
 * @since 21.10.2015
 */
public class EsquemaDadosDao extends CrudDaoDefaultImpl {
	private static final String TABLE_NAME = "esquemadados";

	public EsquemaDadosDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return TABLE_NAME;
	}

	@Override
	public Collection<Field> getFields() {
		final Collection<Field> listFields = new ArrayList<>();
		
		listFields.add(new Field("idEsquemaDados", "idEsquemaDados", true, true, false, false));
		listFields.add(new Field("idServicoNegocio", "idServicoNegocio", false, false, false, false));
		listFields.add(new Field("dataCriacao", "dataCriacao", false, false, false, false));
		listFields.add(new Field("detalhes", "detalhes", false, false, false, false));
		listFields.add(new Field("datafim", "dataFim", false, false, false, false));
		
		return listFields;
	}

	@SuppressWarnings("unchecked")
	public Collection<EsquemaDadosDTO> findByIdServicoNegocio(final Integer idServicoNegocio) throws PersistenceException {
		final List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idServicoNegocio", idServicoNegocio));
		condicao.add(new Condition("dataFim", Condition.IS, null));

		final List<Order> ordenacao = new ArrayList<Order>();
		
		return this.findByCondition(condicao, ordenacao);
	}

	@Override
	public Class<EsquemaDadosDTO> getBean() {
		return EsquemaDadosDTO.class;
	}
}
