package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.EventoDTO;
import br.com.centralit.citcorpore.bean.EventosDTO;
import br.com.centralit.citcorpore.util.Enumerados.GrupoPesquisaAgendamentoAtividadePeriodica;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class EventosDao extends CrudDaoDefaultImpl {

	public EventosDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Class<EventosDTO> getBean() {
		return EventosDTO.class;
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("IDEVENTO", "idEvento", true, true, false, false));
		listFields.add(new Field("IDUSUARIO", "idUsuario", false, false, false, false));
		listFields.add(new Field("IDEMPRESA", "idEmpresa", false, false, false, false));
		listFields.add(new Field("DESCRICAO", "descricao", false, false, false, false));
		listFields.add(new Field("GERARQUANDO", "gerarQuando", false, false, false, false));
		listFields.add(new Field("LIGARCASODESL", "ligarCasoDesl", false, false, false, false));
		listFields.add(new Field("DATACRIACAO", "dataCriacao", false, false, false, false));
		listFields.add(new Field("DATAINICIO", "dataInicio", false, false, false, false));
		listFields.add(new Field("DATAFIM", "dataFim", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "EVENTO";
	}

	public List<EventoDTO> getListEventosMudanca(Integer idGrupoPesquisa) throws Exception {
		StringBuilder sb = new StringBuilder();
		sb.append("SELECT \n");
		sb.append("	DESCRICAO, \n");
		sb.append("	DATAINICIO, \n");
		sb.append("	DATAINICIO, \n");
		sb.append("	'agendado', \n");
		sb.append("	HORAINICIO \n");
		sb.append("FROM \n");
		sb.append("	REUNIAOREQUISICAOMUDANCA \n");
		sb.append("WHERE \n");
		sb.append("	DATAINICIO IS NOT NULL ");

		List<Object> parameters = new ArrayList<>();

		List<Object> result = this.execSQL(sb.toString(), parameters.toArray());

		if(result == null || result.isEmpty()) {
			return new ArrayList<EventoDTO>();
		}

		List<String> fields = new ArrayList<>();
		fields.add("title");
		fields.add("start");
		fields.add("end");
		fields.add("className");
		fields.add("horaInicio");

		return this.listConvertion(EventoDTO.class, result, fields);
	}

	public List<EventoDTO> getListEventosAtividadePeriodica(Integer idGrupoPesquisa, Integer idGrupoAtvPeriodica) throws Exception {
		StringBuilder sb = new StringBuilder();
		List<Object> parameters = new ArrayList<>();

		sb.append("SELECT \n");
		sb.append("	TITULOATIVIDADE, \n");
		sb.append("	PRG.DATAINICIO, \n");
		sb.append("	PRG.DATAINICIO, \n");
		sb.append("	'agendado', \n");
		sb.append("	HORAINICIO, \n");
		sb.append("	ATV.IDSOLICITACAOSERVICO, \n");
		sb.append("	ATV.IDREQUISICAOMUDANCA, \n");
		sb.append("	ATV.IDLIBERACAO, \n");
		sb.append("	ATV.IDPROBLEMA \n");
		sb.append("FROM \n");
		sb.append("	ATIVIDADEPERIODICA ATV \n");
		sb.append("	INNER JOIN PROGRAMACAOATIVIDADE PRG ON PRG.IDATIVIDADEPERIODICA = ATV.IDATIVIDADEPERIODICA \n");
		sb.append("WHERE \n");
		sb.append("	PRG.DATAINICIO IS NOT NULL \n");
		sb.append("	AND ATV.DATAFIM is null \n");

		if (GrupoPesquisaAgendamentoAtividadePeriodica.TODOS.getIdGrupoPesquisa().equals(idGrupoPesquisa)) {
			sb.append("	AND 1 = 1 \n");
		} else if (GrupoPesquisaAgendamentoAtividadePeriodica.INCIDENTE.getIdGrupoPesquisa().equals(idGrupoPesquisa)) {
			sb.append("	AND ATV.IDSOLICITACAOSERVICO IS NOT NULL \n");
		} else if (GrupoPesquisaAgendamentoAtividadePeriodica.MUDANCA.getIdGrupoPesquisa().equals(idGrupoPesquisa)) {
			sb.append("	AND ATV.IDREQUISICAOMUDANCA IS NOT NULL \n");
		} else if (GrupoPesquisaAgendamentoAtividadePeriodica.LIBERACAO.getIdGrupoPesquisa().equals(idGrupoPesquisa)) {
			sb.append("	AND ATV.IDLIBERACAO IS NOT NULL \n");
		} else if (GrupoPesquisaAgendamentoAtividadePeriodica.PROBLEMA.getIdGrupoPesquisa().equals(idGrupoPesquisa)) {
			sb.append("	AND ATV.IDPROBLEMA IS NOT NULL \n");
		}

		if(idGrupoAtvPeriodica != null){
			sb.append("	AND idgrupoatvperiodica = ? ");
			parameters.add(idGrupoAtvPeriodica);
		}

		List<Object> result = this.execSQL(sb.toString(), parameters.toArray());

		if(result == null || result.isEmpty()) {
			return new ArrayList<EventoDTO>();
		}

 		List<String> fields = new ArrayList<>();
		fields.add("title");
		fields.add("start");
		fields.add("end");
		fields.add("className");
		fields.add("horaInicio");
		fields.add("idSolicitacaoServico");
		fields.add("idRequisicaoMudanca");
		fields.add("idRequisicaoLiberacao");
		fields.add("idProblema");

		return this.listConvertion(EventoDTO.class, result, fields);
	}

}
