package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.EvmConexaoDTO;
import br.com.centralit.enums.EvmEnumerados.Ferramentas;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

/**
 * Classe DAO da tela de Manter Conexes com Ferramentas de Monitorao.
 *
 * @author valdoilo.damasceno
 * @version 1.0
 * @created 21-out-2014 16:48:58
 */
@SuppressWarnings("unchecked")
public class EvmConexaoDAO extends CrudDaoDefaultImpl {

	public EvmConexaoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<EvmConexaoDTO> find(final IDto evmConexaoDto) {
		return null;
	}

	@Override
	public Collection<Field> getFields() {
		final Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idConexao", "idConexao", true, true, false, false));
		listFields.add(new Field("nome", "nome", false, false, false, false));
		listFields.add(new Field("ferramenta", "ferramenta", false, false, false, false));
		listFields.add(new Field("protocolo", "protocolo", false, false, false, false));
		listFields.add(new Field("endereco", "endereco", false, false, false, false));
		listFields.add(new Field("porta", "porta", false, false, false, false));
		listFields.add(new Field("usuario", "usuario", false, false, false, false));
		listFields.add(new Field("senha", "senha", false, false, false, false));
		listFields.add(new Field("idUsuarioCriador", "idUsuarioCriador", false, false, false, false));
		listFields.add(new Field("idUsuarioModificador", "idUsuarioModificador", false, false, false, false));
		listFields.add(new Field("dataHoraInicio", "dataHoraInicio", false, false, false, false));
		listFields.add(new Field("dataHoraFim", "dataHoraFim", false, false, false, false));
		listFields.add(new Field("dataHoraUltimaAlteracao", "dataHoraUltimaAlteracao", false, false, false, false));
		listFields.add(new Field("status", "status", false, false, false, false));
		listFields.add(new Field("idEvmConexaoEventMonitor", "idEvmConexaoEventMonitor", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return "evm_conexao";
	}

	@Override
	public Collection<EvmConexaoDTO> list() throws PersistenceException {
		return super.list("nome");
	}

	@Override
	public Class<EvmConexaoDTO> getBean() {
		return EvmConexaoDTO.class;
	}

	/**
	 * @param evmConexaoDto
	 * @return EvmConexaoDTO
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 01.10.2014
	 */
	public EvmConexaoDTO restoreWithInfoAudit(EvmConexaoDTO evmConexaoDto) throws Exception {
		final StringBuilder sql = new StringBuilder();
		final List<Object> parametros = new ArrayList<>();
		final List<Object> fields = new ArrayList<Object>(this.getFields());

		fields.add("nomeUsuarioCriador");
		fields.add("nomeUsuarioModificador");

		final UsuarioDao usuarioDao = new UsuarioDao();

		sql.append(" SELECT " + this.getNamesFieldsStr(this.getTableName()) + ", usuariocriador.nome, usuariomodificador.nome");
		sql.append(" FROM " + this.getTableName());
		sql.append(" INNER JOIN " + usuarioDao.getTableName() + " usuariocriador ON " + this.getTableName() + ".idusuariocriador = usuariocriador.idusuario");
		sql.append(" LEFT JOIN " + usuarioDao.getTableName() + " usuariomodificador ON " + this.getTableName() + ".idusuariomodificador = usuariomodificador.idusuario");
		sql.append(" WHERE " + this.getTableName() + ".idconexao = ?");
		parametros.add(evmConexaoDto.getIdConexao());

		final List<?> dados = this.execSQL(sql.toString(), parametros.toArray());
		if (dados != null && !dados.isEmpty()) {
			final List<?> dadosConvertidos = this.listConvertion(this.getBean(), dados, fields);

			evmConexaoDto = (EvmConexaoDTO) dadosConvertidos.get(0);
		}

		return evmConexaoDto;
	}

	/**
	 * Verifica se existe outra conexo com o mesmo nome.
	 *
	 * @param evmConexaoDto
	 * @return boolean
	 * @author valdoilo.damasceno
	 * @throws Exception
	 * @since 10.10.2014
	 */
	public boolean conexaoExiste(final EvmConexaoDTO evmConexaoDto) throws Exception {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();

		ordenacao.add(new Order("nome"));

		condicao.add(new Condition("nome", "like", evmConexaoDto.getNome()));
		condicao.add(new Condition("dataHoraFim", "is", null));

		if (evmConexaoDto.getIdConexao() != null) {
			condicao.add(new Condition("idConexao", "<>", evmConexaoDto.getIdConexao()));
		}

		final Collection<?> dados = this.findByCondition(condicao, ordenacao);

		if (dados != null && !dados.isEmpty()) {
			return true;
		}
		return false;
	}

	/**
	 * Realiza update dos atributos que no esto Null. Mtodo utilizado pela excluso lgica, para realizar update do campo dataHoraFim.
	 *
	 * @param evmConexaoDto
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 03.11.2014
	 */
	public void updateNotNull(final EvmConexaoDTO evmConexaoDto) throws Exception {
		super.updateNotNull(evmConexaoDto);
	}

	/**
	 * Lista conexes Atividas. Conexes que no estejam com dataHoraFim setadas.
	 *
	 * @return Collection<EvmConexaoDTO>
	 * @author valdoilo.damasceno
	 * @throws Exception
	 * @throws ServiceException
	 * @since 03.11.2014
	 */
	public Collection<EvmConexaoDTO> listarConexoesAtivas() throws Exception {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();
		condicao.add(new Condition("dataHoraFim", "is", null));
		ordenacao.add(new Order("nome"));
		return this.findByCondition(condicao, ordenacao);
	}

	/**
	 * Recupera um Collection das Conexoes com certo ID
	 * 
	 * @param idConexao
	 * @return Collection<EvmConexaoDTO>
	 * @throws Exception
	 * @author thyen.chang
	 */
	public Collection<EvmConexaoDTO> getConexaoById(Integer idConexao) throws Exception {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();
		condicao.add(new Condition("idConexao", "=", idConexao));
		ordenacao.add(new Order("nome"));
		return this.findByCondition(condicao, ordenacao);
	}

	/**
	 * Lista conexes ativas de acordo com a ferramenta informada.
	 *
	 * @return Collection<EvmConexaoDTO>
	 * @throws PersistenceException
	 * @author valdoilo.damasceno
	 * @since 01.04.2015
	 */
	public Collection<EvmConexaoDTO> findByFerramentaMonitoracao(Ferramentas ferramenta) throws PersistenceException {

		final List<Condition> condicao = new ArrayList<>();

		final List<Order> ordenacao = new ArrayList<>();

		condicao.add(new Condition("ferramenta", "=", ferramenta.toString()));
		condicao.add(new Condition("dataHoraFim", "is", null));

		ordenacao.add(new Order("nome"));

		return this.findByCondition(condicao, ordenacao);
	}

	public Collection<EvmConexaoDTO> listarFerramentasAssociadasAoEventMonitor(Integer idEventMonitor) throws Exception {

		final List<Condition> condicao = new ArrayList<>();

		final List<Order> ordenacao = new ArrayList<>();

		condicao.add(new Condition("idEvmConexaoEventMonitor", "=", idEventMonitor));
		condicao.add(new Condition("dataHoraFim", "is", null));

		ordenacao.add(new Order("nome"));

		return this.findByCondition(condicao, ordenacao);
	}

	public Collection<EvmConexaoDTO> getConexaoByIdConexaoEventMonitor(
			Integer idConexaoEventMonitor, String ferramenta) throws PersistenceException {
		final List<Condition> condicao = new ArrayList<>();

		final List<Order> ordenacao = new ArrayList<>();

		condicao.add(new Condition("idEvmConexaoEventMonitor", "=", idConexaoEventMonitor.intValue()));
		condicao.add(new Condition("dataHoraFim", "is", null));
		condicao.add(new Condition("ferramenta", "=", ferramenta));

		ordenacao.add(new Order("nome"));

		return this.findByCondition(condicao, ordenacao);
	}

	public String getFerramentaByIdConexao(Integer idConexao) throws Exception {
		
		final List<Condition> condicao = new ArrayList<>();

		final List<Order> ordenacao = new ArrayList<>();

		condicao.add(new Condition("idConexao", "=", idConexao.intValue()));
		condicao.add(new Condition("dataHoraFim", "is", null));

		List<EvmConexaoDTO> conexoes = (List<EvmConexaoDTO>) this.findByCondition(condicao, ordenacao);
		
		if(conexoes != null && !conexoes.isEmpty()){
			EvmConexaoDTO evmConexaoDto = conexoes.get(0);
			
			if(evmConexaoDto!=null && evmConexaoDto.getFerramenta() != null){
				return evmConexaoDto.getFerramenta();
			}
		}
		
		return null;
		
	}

}
