package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.EvmCronDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

/**
 * @author valdoilo.damasceno
 * @author VALDOILO MARQUES DAMASCENO
 * @version 1.0
 * @created 21-out-2014 16:48:58
 */
public class EvmCronDAO extends CrudDaoDefaultImpl {

	private EvmInventoryConfiguracaoDAO evmInventoryConfiguracaoDAO;

	private static final long serialVersionUID = -7124296406684704992L;

	public EvmCronDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<EvmCronDTO> find(final IDto obj) {
		return null;
	}

	@Override
	public Collection<Field> getFields() {
		final Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idCron", "idCron", true, true, false, false));
		listFields.add(new Field("nome", "nome", false, false, false, false));
		listFields.add(new Field("expressao", "expressao", false, false, false, false));
		listFields.add(new Field("idUsuarioCriador", "idUsuarioCriador", false, false, false, false));
		listFields.add(new Field("idUsuarioModificador", "idUsuarioModificador", false, false, false, false));
		listFields.add(new Field("dataHoraInicio", "dataHoraInicio", false, false, false, false));
		listFields.add(new Field("dataHoraFim", "dataHoraFim", false, false, false, false));
		listFields.add(new Field("dataHoraUltimaAlteracao", "dataHoraUltimaAlteracao", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return "evm_cron";
	}

	@Override
	public Collection<EvmCronDTO> list() throws PersistenceException {
		return super.list("nome");
	}

	@Override
	public Class<EvmCronDTO> getBean() {
		return EvmCronDTO.class;
	}

	/**
	 * @param evmCronDto
	 * @return
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 03.11.2014
	 */
	public EvmCronDTO restoreWithInfoAudit(EvmCronDTO evmCronDto) throws Exception {
		final StringBuilder sql = new StringBuilder();
		final List<Object> parametros = new ArrayList<Object>();
		final List<Object> fields = new ArrayList<Object>(this.getFields());

		fields.add("nomeUsuarioCriador");
		fields.add("nomeUsuarioModificador");

		final UsuarioDao usuarioDao = new UsuarioDao();

		sql.append(" SELECT " + this.getNamesFieldsStr(this.getTableName()) + ", usuariocriador.nome, usuariomodificador.nome");
		sql.append(" FROM " + this.getTableName());
		sql.append(" INNER JOIN " + usuarioDao.getTableName() + " usuariocriador ON " + this.getTableName() + ".idusuariocriador = usuariocriador.idusuario");
		sql.append(" LEFT JOIN " + usuarioDao.getTableName() + " usuariomodificador ON " + this.getTableName() + ".idusuariomodificador = usuariomodificador.idusuario");
		sql.append(" WHERE " + this.getTableName() + ".idcron = ?");
		parametros.add(evmCronDto.getIdCron());

		final List<?> dados = this.execSQL(sql.toString(), parametros.toArray());

		if (dados != null && !dados.isEmpty()) {
			final List<?> dadosConvertidos = this.listConvertion(this.getBean(), dados, fields);
			evmCronDto = (EvmCronDTO) dadosConvertidos.get(0);
		}

		return evmCronDto;
	}

	/**
	 * Verifica se existe outra expresso cron com o mesmo nome.
	 *
	 * @param evmCronDto
	 * @return boolean
	 * @author valdoilo.damasceno
	 * @throws Exception
	 * @since 03.11.2014
	 */
	public boolean cronExiste(final EvmCronDTO evmCronDto) throws Exception {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();

		ordenacao.add(new Order("nome"));

		condicao.add(new Condition("nome", "like", evmCronDto.getNome()));
		// condicao.add(new Condition(Condition.OR, "expressao", "like", evmCronDto.getExpressao()));
		condicao.add(new Condition("dataHoraFim", "is", null));

		if (evmCronDto.getIdCron() != null) {
			condicao.add(new Condition("idCron", "<>", evmCronDto.getIdCron()));
		}

		final Collection<?> dados = this.findByCondition(condicao, ordenacao);

		if (dados != null && !dados.isEmpty()) {
			return true;
		}
		return false;
	}

	/**
	 * Realiza update dos atributos que no esto Null. Mtodo utilizado pela excluso lgica, para realizar update do campo dataHoraFim.
	 *
	 * @param evmCronDto
	 * @author valdoilo.damasceno
	 * @throws Exception
	 * @since 03.11.2014
	 */
	public void updateNotNull(final EvmCronDTO evmCronDto) throws Exception {
		super.updateNotNull(evmCronDto);
	}

	/**
	 * Lista expresses cron Atividas. Expresses que no estejam com dataHoraFim setadas.
	 *
	 * @return Collection<EvmCronDTO>
	 * @author valdoilo.damasceno
	 * @throws Exception
	 * @throws ServiceException
	 * @since 03.11.2014
	 */
	public Collection<EvmCronDTO> listarExpressoesCronAtivas() throws Exception {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();

		condicao.add(new Condition("dataHoraFim", "is", null));

		ordenacao.add(new Order("nome"));

		return this.findByCondition(condicao, ordenacao);
	}

	/**
	 * Verifica se a expressao cron possui referencia nos Gerentes.
	 *
	 * @param evmCronDto
	 * @return boolean
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 03.11.2014
	 */
	public boolean possuiRelacionamento(final EvmCronDTO evmCronDto) throws Exception {
		return this.getEvmInventoryConfiguracaoDAO().possuiRelacionamentoComEvmCron(evmCronDto);
	}

	/**
	 * Obtem instancia de EvmGerenteDAO.
	 *
	 * @return EvmInventoryConfiguracaoDAO
	 * @author euler.ramos
	 * @since 15.04.2015
	 */
	public EvmInventoryConfiguracaoDAO getEvmInventoryConfiguracaoDAO() {
		if (evmInventoryConfiguracaoDAO == null) {
			evmInventoryConfiguracaoDAO = new EvmInventoryConfiguracaoDAO();
		}
		return evmInventoryConfiguracaoDAO;
	}
}
