package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.EvmCronDTO;
import br.com.centralit.citcorpore.bean.EvmInventoryConfiguracaoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class EvmInventoryConfiguracaoDAO extends CrudDaoDefaultImpl {

    public EvmInventoryConfiguracaoDAO() {
        super(Constantes.getValue("DATABASE_ALIAS"), null);
    }

    @Override
    public Collection<EvmInventoryConfiguracaoDTO> find(final IDto obj) {
        return null;
    }

    @Override
    public Collection<Field> getFields() {
        final Collection<Field> listFields = new ArrayList<Field>();

        listFields.add(new Field("idConfiguracao", "idConfiguracao", true, true, false, true));
        listFields.add(new Field("idInventory", "idInventory", false, false, false, false));
        listFields.add(new Field("faixaIp", "faixaIp", false, false, false, false));
        listFields.add(new Field("contexto", "contexto", false, false, false, false));
        listFields.add(new Field("ipServidor", "ipServidor", false, false, false, false));
        listFields.add(new Field("portaNet", "portaNet", false, false, false, false));
        listFields.add(new Field("timeout", "timeout", false, false, false, false));
        listFields.add(new Field("numeroTentativas", "numeroTentativas", false, false, false, false));
        listFields.add(new Field("portaSNMP", "portaSNMP", false, false, false, false));
        listFields.add(new Field("nomeSNMPCommunity", "nomeSNMPCommunity", false, false, false, false));
        listFields.add(new Field("idFormula", "idFormula", false, false, false, false));
        listFields.add(new Field("dataHoraInicio", "dataHoraInicio", false, false, false, false));
        listFields.add(new Field("dataHoraFim", "dataHoraFim", false, false, false, false));
        listFields.add(new Field("idConexao", "idConexao", false, false, false, false));
        listFields.add(new Field("conteudoFormula", "conteudoFormula", false, false, false, false));
        listFields.add(new Field("idCron", "idCron", false, false, false, false));
        listFields.add(new Field("expressaoCron", "expressaoCron", false, false, false, false));
        listFields.add(new Field("destinoInventario", "destinoInventario", false, false, false, false));
        listFields.add(new Field("idEvmConexaoEventMonitor", "idEvmConexaoEventMonitor", false, false, false, false));
		listFields.add(new Field("ignoraricsinventariados", "ignorarIcsInventariados", false, false, false, false));
		listFields.add(new Field("tempoignorarics", "tempoIgnorarIcs", false, false, false, false));
		listFields.add(new Field("tipoignorarics", "tipoIgnorarIcs", false, false, false, false));

        return listFields;
    }

    @Override
    public String getTableName() {
        return "evm_inventory_configuracao";
    }

    @Override
    public Collection<EvmInventoryConfiguracaoDTO> list() {
        return null;
    }

    @Override
    public Class<EvmInventoryConfiguracaoDTO> getBean() {
        return EvmInventoryConfiguracaoDTO.class;
    }

    public EvmInventoryConfiguracaoDTO findConfiguracaoById(final Integer idConfiguracao) throws Exception {
        final StringBuilder sql = new StringBuilder();
        final List<Object> parametros = new ArrayList<Object>();
        final List<Object> fields = new ArrayList<Object>(this.getFields());

        sql.append(" SELECT " + this.getNamesFieldsStr(this.getTableName()));
        sql.append(" FROM " + this.getTableName());
        sql.append(" WHERE idconfiguracao = ? ");
        parametros.add(idConfiguracao);
        sql.append("AND datahorafim IS NULL");

        final List<?> dados = this.execSQL(sql.toString(), parametros.toArray());

        EvmInventoryConfiguracaoDTO configuracaoDTO = new EvmInventoryConfiguracaoDTO();

        if (dados != null && !dados.isEmpty()) {
            final List<?> dadosConvertidos = this.listConvertion(this.getBean(), dados, fields);
            configuracaoDTO = (EvmInventoryConfiguracaoDTO) dadosConvertidos.get(0);
        }

        return configuracaoDTO;
    }
    
    public EvmInventoryConfiguracaoDTO findConfiguracaoByIdConexao(final Integer idConexao) throws Exception {
        final StringBuilder sql = new StringBuilder();
        final List<Object> parametros = new ArrayList<Object>();
        final List<Object> fields = new ArrayList<Object>(this.getFields());

        sql.append(" SELECT " + this.getNamesFieldsStr(this.getTableName()));
        sql.append(" FROM " + this.getTableName());
        sql.append(" WHERE idConexao = ? ");
        parametros.add(idConexao);
        sql.append("AND datahorafim IS NULL");

        final List<?> dados = this.execSQL(sql.toString(), parametros.toArray());

        EvmInventoryConfiguracaoDTO configuracaoDTO = new EvmInventoryConfiguracaoDTO();

        if (dados != null && !dados.isEmpty()) {
            final List<?> dadosConvertidos = this.listConvertion(this.getBean(), dados, fields);
            configuracaoDTO = (EvmInventoryConfiguracaoDTO) dadosConvertidos.get(0);
        }

        return configuracaoDTO;
    }    

    public void updateNotNull(final EvmInventoryConfiguracaoDTO configuracaoDTO) throws ServiceException, Exception {
        super.updateNotNull(configuracaoDTO);
    }

    public boolean configuracaoExiste(final EvmInventoryConfiguracaoDTO configuracaoDTO) throws Exception {
        final List<Condition> condicao = new ArrayList<>();
        final List<Order> ordenacao = new ArrayList<>();

        ordenacao.add(new Order("idInventory"));

        condicao.add(new Condition("idInventory", "like", configuracaoDTO.getIdInventory()));
        condicao.add(new Condition("dataHoraFim", "is", null));

        if (configuracaoDTO.getIdConfiguracao() != null) {
            condicao.add(new Condition("idConfiguracao", "<>", configuracaoDTO.getIdConfiguracao()));
        }

        final Collection<?> dados = this.findByCondition(condicao, ordenacao);

        if (dados != null && !dados.isEmpty()) {
            return true;
        }
        return false;
    }
    
    @SuppressWarnings("unchecked")
	public List<EvmInventoryConfiguracaoDTO> listInventoryAtivo() throws Exception{
    	final StringBuilder sql = new StringBuilder();
        final List<Object> parametros = new ArrayList<Object>();
        final List<Object> fields = new ArrayList<Object>();
        
        fields.add("idInventory");
        fields.add("idConfiguracao");
        fields.add("idConexao");

        sql.append(" SELECT emc.idinventory, emc.idconfiguracao, ec.idconexao ");
		sql.append(" FROM " + this.getTableName());
		sql.append(" JOIN evm_conexao ec ON evm_inventory_configuracao.idconexao = evm_conexao.idconexao ");
		sql.append(" WHERE evm_conexao.status = 'ATIVO' ");
		sql.append(" AND evm_inventory_configuracao.datahorafim IS NULL");

        final List<?> dados = this.execSQL(sql.toString(), parametros.toArray());

        if (dados != null && !dados.isEmpty()) {
            final List<EvmInventoryConfiguracaoDTO> dadosConvertidos = this.listConvertion(this.getBean(), dados, fields);
            return dadosConvertidos;
        }
		//Se no tiver nada, retorna uma lista vazia
        return new ArrayList<EvmInventoryConfiguracaoDTO>();
    }
    
    public EvmInventoryConfiguracaoDTO getByIdInventory(final String idInventory) throws Exception {
        final StringBuilder sql = new StringBuilder();
        final List<Object> parametros = new ArrayList<Object>();
        final List<Object> fields = new ArrayList<Object>(this.getFields());

        sql.append(" SELECT " + this.getNamesFieldsStr(this.getTableName()));
		sql.append(" FROM " + this.getTableName());
		sql.append(" JOIN evm_conexao ON evm_inventory_configuracao.idconexao = evm_conexao.idconexao ");
		sql.append(" WHERE evm_inventory_configuracao.idinventory = ? ");
		sql.append(" AND evm_conexao.status = 'ATIVO' ");
		sql.append(" AND evm_inventory_configuracao.datahorafim IS NULL");

        parametros.add(idInventory);

        final List<?> dados = this.execSQL(sql.toString(), parametros.toArray());

        EvmInventoryConfiguracaoDTO configuracaoDTO = new EvmInventoryConfiguracaoDTO();

        if (dados != null && !dados.isEmpty()) {
            final List<?> dadosConvertidos = this.listConvertion(this.getBean(), dados, fields);
            configuracaoDTO = (EvmInventoryConfiguracaoDTO) dadosConvertidos.get(0);
        }

        return configuracaoDTO;
    }

	/**
	 * Verifica se h relacionamento de algum gerente com o EvmCron informado.
	 *
	 * @param evmCronDto
	 * @return boolean
	 * @throws Exception
	 * @author euler.ramos
	 * @since 15.04.2015
	 */
	public boolean possuiRelacionamentoComEvmCron(final EvmCronDTO evmCronDto) throws Exception {
		Collection<EvmInventoryConfiguracaoDTO> listEvmInventoryConfiguracaoDTO = new ArrayList<>();

		if (evmCronDto != null && evmCronDto.getIdCron() != null) {
			final List<Condition> condicao = new ArrayList<>();
			final List<Order> ordenacao = new ArrayList<>();

			condicao.add(new Condition("dataHoraFim", "is", null));
			condicao.add(new Condition("idCron", "=", evmCronDto.getIdCron()));

			listEvmInventoryConfiguracaoDTO = this.findByCondition(condicao, ordenacao);
		}

		if (listEvmInventoryConfiguracaoDTO != null && !listEvmInventoryConfiguracaoDTO.isEmpty()) {
			return true;
		}
		return false;
	}

}
