package br.com.centralit.citcorpore.integracao;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ExcecaoCalendarioDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

@SuppressWarnings({"unchecked","rawtypes"})
public class ExcecaoCalendarioDao extends CrudDaoDefaultImpl {
	
	public ExcecaoCalendarioDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}
	
	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idExcecaoCalendario" ,"idExcecaoCalendario", true, true, false, false));
		listFields.add(new Field("idCalendario" ,"idCalendario", false, false, false, false));
		listFields.add(new Field("idJornada" ,"idJornada", false, false, false, false));
		listFields.add(new Field("tipo" ,"tipo", false, false, false, false));
		listFields.add(new Field("dataInicio" ,"dataInicio", false, false, false, false));
		listFields.add(new Field("dataTermino" ,"dataTermino", false, false, false, false));
		return listFields;
	}
	
	@Override
	public String getTableName() {
		return this.getOwner() + "ExcecaoCalendario";
	}
	
	@Override
	public Collection list() throws PersistenceException {
		return null;
	}

	
	@Override
	public Class getBean() {
		return ExcecaoCalendarioDTO.class;
	}
	
	@Override
	public Collection find(IDto arg0) throws PersistenceException {
		return null;
	}
	
	public Collection findByIdCalendario(Integer idCalendario) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList(); 
		condicao.add(new Condition("idCalendario", "=", idCalendario)); 
		ordenacao.add(new Order("dataInicio"));
		return super.findByCondition(condicao, ordenacao);
	}
	
	public void deleteByIdCalendario(Integer idCalendario) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idCalendario", "=", idCalendario));
		super.deleteByCondition(condicao);
	}
	
	public ExcecaoCalendarioDTO findByIdCalendarioAndData(Integer idCalendario, Date data) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList(); 
		condicao.add(new Condition("idCalendario", "=", idCalendario)); 
		condicao.add(new Condition("dataInicio", "<=", data)); 
		condicao.add(new Condition("dataTermino", ">=", data)); 
		ordenacao.add(new Order("dataInicio"));
		List result = (List) super.findByCondition(condicao, ordenacao);
		if (result != null && !result.isEmpty())
			return (ExcecaoCalendarioDTO) result.get(0);
		else
			return null;
	}
	
	public List getListFeriadosAnoCorrente(Integer idCalendario) throws PersistenceException {

		List retorno = new ArrayList();
		List parametros = new ArrayList();
		List result = new ArrayList();

		StringBuilder sql = new StringBuilder();

		sql.append("SELECT ").append(getNamesFieldsStr());
		sql.append(" FROM ").append(getTableName());
		sql.append(" WHERE ");
		sql.append(" idcalendario = ? ");
		
		if(idCalendario != null){
			parametros.add(idCalendario);
		} else {
			parametros.add(0);
		}

		if (CITCorporeUtil.SGBD_PRINCIPAL.trim().equalsIgnoreCase("SQLSERVER")) {
			sql.append(" AND YEAR(datainicio) = (SELECT YEAR(getdate())) ");
		} else if (CITCorporeUtil.SGBD_PRINCIPAL.trim().equalsIgnoreCase("ORACLE")) {
			sql.append(" AND EXTRACT(YEAR FROM datainicio) = (SELECT EXTRACT(YEAR FROM SYSDATE) FROM dual) ");
		}else{
			sql.append(" AND (SELECT EXTRACT(YEAR FROM datainicio)) = (SELECT EXTRACT(YEAR FROM NOW())) ");
		}

		sql.append(" AND idjornada IS NULL;");

		result = this.execSQL(sql.toString(), parametros.toArray());

		List fields = new ArrayList();
		fields.add("idExcecaoCalendario");
		fields.add("idCalendario");
		fields.add("idJornada");
		fields.add("tipo");
		fields.add("dataInicio");
		fields.add("dataTermino");

		if (result != null && !result.isEmpty()) {
			retorno = listConvertion(getBean(), result, fields);
		} else {
			return null;
		}

		if (retorno != null && !retorno.isEmpty()) {
			return retorno;
		} else {
			return null;
		}
	}
}
