package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioBusinessUserDTO;
import br.com.centralit.citcorpore.util.Util;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class GerenciamentoPortfolioBusinessUserDao extends CrudDaoDefaultImpl {

	private List<Field> listFields;

	public GerenciamentoPortfolioBusinessUserDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "portfoliobusinessuser";
	}

	@Override
	public Collection<Field> getFields() {
		if (listFields == null) {
			listFields = new ArrayList<>();
			listFields.add(new Field("idbusinessuser", "idBusinessUser", true, true, false, false));
			listFields.add(new Field("idservico", "idServicoAtual", false, false, false, false));
			listFields.add(new Field("idgrupo", "idGrupoUsuario", false, false, false, false));
			listFields.add(new Field("idusuario", "idUsuario", false, false, false, false));
			listFields.add(new Field("tipo", "tipo", false, false, false, false));
		}
		return listFields;
	}

	public Collection<GerenciamentoPortfolioBusinessUserDTO> listByServico(Integer idServico) throws PersistenceException {
		List<Condition> condicao = new ArrayList<>();
		condicao.add(new Condition("idServicoAtual", "=", idServico));
		return super.findByCondition(condicao, null);
	}

	public Collection<GerenciamentoPortfolioBusinessUserDTO> listByServicoAndText(Integer idServicoAtual, String text) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();

		List<GerenciamentoPortfolioBusinessUserDTO> result = new ArrayList<>();
		List<String> listFieldClassParaPopular = new ArrayList<>();
		Collection<GerenciamentoPortfolioBusinessUserDTO> listaVinculo;

		listFieldClassParaPopular.add("idBusinessUser");
		listFieldClassParaPopular.add("idServicoAtual");
		listFieldClassParaPopular.add("idUsuario");
		listFieldClassParaPopular.add("tipo");

		parametros.add(idServicoAtual);

		sql.append("SELECT BU.IDBUSINESSUSER, BU.IDSERVICO, BU.IDUSUARIO, BU.TIPO  ");
		sql.append("FROM PORTFOLIOBUSINESSUSER BU INNER JOIN USUARIO U ON BU.IDUSUARIO = U.IDUSUARIO ");
		sql.append("WHERE IDSERVICO = ? AND ").append(Util.getQueryLikeWithCaseInsensitiveAndAccentInsensitive(MAIN_SGBD, "U.NOME", text));
		result = this.execSQL(sql.toString(), parametros.toArray());
		listaVinculo = this.engine.listConvertion(getBean(), result, listFieldClassParaPopular);

		listFieldClassParaPopular.clear();
		listFieldClassParaPopular.add("idBusinessUser");
		listFieldClassParaPopular.add("idServicoAtual");
		listFieldClassParaPopular.add("idGrupoUsuario");
		listFieldClassParaPopular.add("tipo");

		sql.delete(0, sql.length());
		sql.append("SELECT BU.IDBUSINESSUSER, BU.IDSERVICO, BU.IDGRUPO, BU.TIPO ");
		sql.append("FROM PORTFOLIOBUSINESSUSER BU INNER JOIN GRUPO G ON BU.IDGRUPO = G.IDGRUPO ");
		sql.append("WHERE IDSERVICO = ? AND ").append(Util.getQueryLikeWithCaseInsensitiveAndAccentInsensitive(MAIN_SGBD, "G.NOME", text));
		result = this.execSQL(sql.toString(), parametros.toArray());
		listaVinculo.addAll(this.engine.listConvertion(getBean(), result, listFieldClassParaPopular));

		return listaVinculo;

	}

	@Override
	public Class<GerenciamentoPortfolioBusinessUserDTO> getBean() {
		return GerenciamentoPortfolioBusinessUserDTO.class;
	}

}
