package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioHabilidadeDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class GerenciamentoPortfolioHabilidadeDao extends CrudDaoDefaultImpl {

	public GerenciamentoPortfolioHabilidadeDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public List<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("IDHABILIDADEVINCULO", "idHabilidadeVinculo", true, true, false, false));
		listFields.add(new Field("IDHABILIDADE", "idHabilidade", false, false, false, false));
		listFields.add(new Field("IDSERVICO", "idServico", false, false, false, false));
		listFields.add(new Field("DATAFIM", "dataFim", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "HABILIDADESERVICO";
	}

	@Override
	public Class<GerenciamentoPortfolioHabilidadeDTO> getBean() {
		return GerenciamentoPortfolioHabilidadeDTO.class;
	}

	@SuppressWarnings("unchecked")
	public Collection<GerenciamentoPortfolioHabilidadeDTO> getListHabilidadesByIdServico(GerenciamentoPortfolioHabilidadeDTO habilidadeDTO) throws PersistenceException {
		final StringBuilder sql = new StringBuilder();
		final List<Object> listFields = new ArrayList<>();

		List<GerenciamentoPortfolioHabilidadeDTO> list = new ArrayList<>();

		final List<Integer> parametro = new ArrayList<Integer>();

		sql.append(" SELECT hab.idhabilidade, ");
		sql.append("        hab.nomehabilidade, ");
		sql.append("        servico.idhabilidadevinculo");
		sql.append(" FROM   habilidade hab ");
		sql.append(" INNER JOIN   habilidadeservico servico ");
		sql.append(" ON  hab.idhabilidade = servico.idhabilidade ");
		sql.append(" WHERE  servico.idservico = ? ");
		sql.append(" AND    hab.datahorafim is null");
		sql.append(" ORDER  BY hab.nomehabilidade ");

		parametro.add(habilidadeDTO.getIdServico());
		list = this.execSQL(sql.toString(), parametro.toArray());

		listFields.add("idHabilidade");
		listFields.add("nomeHabilidade");
		listFields.add("idHabilidadeVinculo");

		Collection<GerenciamentoPortfolioHabilidadeDTO> listaRetorno = null;

		if (list != null && !list.isEmpty()) {
			listaRetorno = this.listConvertion(this.getBean(), list, listFields);
		} else {
			listaRetorno = new ArrayList<GerenciamentoPortfolioHabilidadeDTO>();
		}

		return listaRetorno;
	}

	public void deleteAllVinculosHabilidade(final Integer idServico) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idServico", idServico));
		super.deleteByCondition(condicao);
	}

	public void deleteByIdHabilidadeVinculo(final Integer idHabilidadeVinculo) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idHabilidadeVinculo", idHabilidadeVinculo));
		super.deleteByCondition(condicao);
	}

	public Collection<GerenciamentoPortfolioHabilidadeDTO> listHabilidadeByFiltro(GerenciamentoPortfolioHabilidadeDTO habilidadeDTO, String filtro) throws PersistenceException {
		final StringBuilder sql = new StringBuilder();
		final List<Object> listFields = new ArrayList<>();

		List<GerenciamentoPortfolioHabilidadeDTO> list = new ArrayList<>();

		final List parametro = new ArrayList();

		sql.append(" SELECT hab.idhabilidade, ");
		sql.append("        hab.nomehabilidade, ");
		sql.append("        servico.idhabilidadevinculo");
		sql.append(" FROM   habilidade hab ");
		sql.append(" INNER JOIN   habilidadeservico servico ");
		sql.append(" ON  hab.idhabilidade = servico.idhabilidade ");
		sql.append(" WHERE  servico.idservico = ? ");
		sql.append(" AND    hab.nomehabilidade like ? ");
		sql.append(" AND    hab.datahorafim is null");
		sql.append(" ORDER  BY hab.nomehabilidade ");

		parametro.add(habilidadeDTO.getIdServico());
		parametro.add("%" + filtro + "%");

		list = this.execSQL(sql.toString(), parametro.toArray());

		listFields.add("idHabilidade");
		listFields.add("nomeHabilidade");
		listFields.add("idHabilidadeVinculo");

		Collection<GerenciamentoPortfolioHabilidadeDTO> listaRetorno = null;

		if (list != null && !list.isEmpty()) {
			listaRetorno = this.listConvertion(this.getBean(), list, listFields);
		} else {
			listaRetorno = new ArrayList<GerenciamentoPortfolioHabilidadeDTO>();
		}

		return listaRetorno;
	}

}
