package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.GrupoICValorIndisponibilidadeDTO;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

@SuppressWarnings("unchecked")
public class GrupoICValorIndisponibilidadeDao extends CrudDaoDefaultImpl {
    public GrupoICValorIndisponibilidadeDao() {
        super(Constantes.getValue("DATABASE_ALIAS"), null);
    }

    @Override
    public Collection<Field> getFields() {
        Collection<Field> listFields = new ArrayList<>();
        listFields.add(new Field("idGrupoICValorIndisp" ,"idGrupoICValorIndisp", true, true, false, false));
        listFields.add(new Field("idGrupoItemConfiguracao" ,"idGrupoItemConfiguracao", false, false, false, false));
        listFields.add(new Field("valor" ,"valor", false, false, false, false));
        return listFields;
    }
    @Override
    public String getTableName() {
        return "GRUPOICVALORINDISP";
    }

	@Override
	public Class<GrupoICValorIndisponibilidadeDTO> getBean() {
		return GrupoICValorIndisponibilidadeDTO.class;
	}
	
	public Collection<GrupoICValorIndisponibilidadeDTO> findByIdGrupoItemConfiguracao(Integer idGrupoItemConfiguracao) throws Exception {
		List<Condition> condicao = new ArrayList<>();
		condicao.add(new Condition("idGrupoItemConfiguracao", Condition.EQUALS, idGrupoItemConfiguracao));
		return this.findByCondition(condicao, new ArrayList<>());
	}
	
	public void deleteByIdGrupoItemConfiguracao(Integer idGrupoItemConfiguracao) throws Exception {
		List<Condition> condicao = new ArrayList<>();
		condicao.add(new Condition("idGrupoItemConfiguracao", Condition.EQUALS, idGrupoItemConfiguracao));
		this.deleteByCondition(condicao);
	}
}
