package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.GrupoItemConfiguracaoAcordoNivelServicoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class GrupoItemConfiguracaoAcordoNivelServicoDao extends CrudDaoDefaultImpl {

	public GrupoItemConfiguracaoAcordoNivelServicoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection find(IDto obj) throws PersistenceException {

		return null;
	}

	@Override
	public Collection<Field> getFields() {

		Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idGrupoItemConfiguracao", "idGrupoItemConfiguracao", true, false, false, false));
		listFields.add(new Field("idAcordoNivelServico", "idAcordoNivelServico", true, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "GRUPOICCACORDONIVELSERVICO";
	}

	@Override
	public Class getBean() {
		return GrupoItemConfiguracaoAcordoNivelServicoDTO.class;
	}

	public void deleteByIdAcordoNivelServico(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idAcordoNivelServico", "=", parm));
		super.deleteByCondition(condicao);
	}

	public void deleteByIdGrupoItemConfiguracao(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idGrupoItemConfiguracao", "=", parm));
		super.deleteByCondition(condicao);
	}

	public Collection findByIdAcordoNivelServico(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idAcordoNivelServico", "=", parm));
		return super.findByCondition(condicao, ordenacao);
	}

	public Collection findByIdGrupoItemConfiguracao(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idGrupoItemConfiguracao", "=", parm));
		return super.findByCondition(condicao, ordenacao);
	}

}
