package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.GrupoItemConfiguracaoCalendarioDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class GrupoItemConfiguracaoCalendarioDao extends CrudDaoDefaultImpl {

	public GrupoItemConfiguracaoCalendarioDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection find(IDto obj) throws PersistenceException {

		return null;
	}

	@Override
	public Collection<Field> getFields() {

		Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idGrupoItemConfiguracao", "idGrupoItemConfiguracao", true, false, false, false));
		listFields.add(new Field("idCalendario", "idCalendario", true, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "GRUPOICCALENDARIO";
	}

	@Override
	public Class getBean() {
		return GrupoItemConfiguracaoCalendarioDTO.class;
	}

	public void deleteByIdCalendario(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idCalendario", "=", parm));
		super.deleteByCondition(condicao);
	}

	public void deleteByIdGrupoItemConfiguracao(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idGrupoItemConfiguracao", "=", parm));
		super.deleteByCondition(condicao);
	}

	public Collection findByIdCalendario(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idCalendario", "=", parm));
		return super.findByCondition(condicao, ordenacao);
	}

	public Collection findByIdGrupoItemConfiguracao(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idGrupoItemConfiguracao", "=", parm));
		return super.findByCondition(condicao, ordenacao);
	}

}
