/**
 * 
 */
package br.com.centralit.citcorpore.integracao;

import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import br.com.centralit.citcorpore.bean.BaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.HistoricoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.SQLConfig;
import br.com.citframework.util.UtilDatas;

/**
 * @author Vadoilo Damasceno
 * 
 */
@SuppressWarnings({ "rawtypes", "unchecked" })
public class HistoricoBaseConhecimentoDAO extends CrudDaoDefaultImpl {

	public HistoricoBaseConhecimentoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection find(IDto obj) throws PersistenceException {
		return null;
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("IDHISTORICOBASECONHECIMENTO", "idHistoricoBaseConhecimento", true, true, false, false));
		listFields.add(new Field("IDBASECONHECIMENTO", "idBaseConhecimento", true, false, false, false));
		listFields.add(new Field("IDPASTA", "idPasta", false, false, false, false));
		listFields.add(new Field("DATAINICIO", "dataInicio", false, false, false, false));
		listFields.add(new Field("DATAFIM", "dataFim", false, false, false, false));
		listFields.add(new Field("TITULO", "titulo", false, false, false, false));
		listFields.add(new Field("CONTEUDO", "conteudo", false, false, false, false));
		listFields.add(new Field("STATUS", "status", false, false, false, false));
		listFields.add(new Field("IDBASECONHECIMENTOPAI", "idBaseConhecimentoPai", false, false, false, false));
		listFields.add(new Field("DATAEXPIRACAO", "dataExpiracao", false, false, false, false));
		listFields.add(new Field("VERSAO", "versao", false, false, false, false));
		listFields.add(new Field("IDUSUARIOAUTOR", "idUsuarioAutor", false, false, false, false));
		listFields.add(new Field("IDUSUARIOAPROVADOR", "idUsuarioAprovador", false, false, false, false));
		listFields.add(new Field("FONTEREFERENCIA", "fonteReferencia", false, false, false, false));
		listFields.add(new Field("DATAPUBLICACAO", "dataPublicacao", false, false, false, false));
		listFields.add(new Field("IDNOTIFICACAO", "idNotificacao", false, false, false, false));
		listFields.add(new Field("JUSTIFICATIVAOBSERVACAO", "justificativaObservacao", false, false, false, false));
		listFields.add(new Field("FAQ", "faq", false, false, false, false));
		listFields.add(new Field("ORIGEM", "origem", false, false, false, false));
		listFields.add(new Field("ARQUIVADO", "arquivado", false, false, false, false));
		listFields.add(new Field("IDUSUARIOALTERACAO", "idUsuarioAlteracao", false, false, false, false));
		listFields.add(new Field("DATAHORAALTERACAO", "dataHoraAlteracao", false, false, false, false));
		listFields.add(new Field("erroConhecido", "erroConhecido", false, false, false, false));
		listFields.add(new Field("tipoDocumento", "tipoDocumento", false, false, false, false));
		listFields.add(new Field("idbaseconhecimentoorigem", "idBaseConhecimentoOrigem", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "HISTORICOBASECONHECIMENTO";
	}
	
	@Override
	public void updateNotNull(IDto obj) throws PersistenceException {
		super.updateNotNull(obj);
	}

	@Override
	public Collection list() throws PersistenceException {
		List ordenacao = new ArrayList();
		ordenacao.add(new Order("idHistoricoBaseConhecimento"));
		return super.list(ordenacao);
	}

	@Override
	public Class getBean() {
		return HistoricoBaseConhecimentoDTO.class;
	}

	/**
	 * Retorna lista de historico de alterao da Base de Conhecimento informada.
	 * 
	 * @param baseConhecimento
	 * @return Collection<BaseConhecimentoDTO>
	 * @throws Exception
	 * @author Thays.araujo
	 */
	public Collection<HistoricoBaseConhecimentoDTO> obterHistoricoDeAlteracao(String titulo) throws PersistenceException {
		List<Condition> condition = new ArrayList<>();
		String[] titulos = titulo.split(" - v[\\d]+.[\\d]+");
		condition.add(new Condition("titulo", Condition.LIKE, ((titulos != null && titulos.length > 0) ? titulos[0] : titulo) + "%"));
		List<Order> order = new ArrayList<Order>();
		order.add(new Order("versao"));

		return this.findByCondition(condition, order);
	}

	public Collection<HistoricoBaseConhecimentoDTO> restoreHistoricoFromIdBaseConhecimento(HistoricoBaseConhecimentoDTO historicoBaseConhecimentoDTO) throws Exception {
		List<Condition> condition = new ArrayList<>();
		condition.add(new Condition("idBaseConhecimento", Condition.EQUALS, historicoBaseConhecimentoDTO.getIdBaseConhecimento()));
		List<Order> order = new ArrayList<>();
		return this.findByCondition(condition, order);
	}
	
	public Collection<HistoricoBaseConhecimentoDTO> getHistoricoDeVersoes(BaseConhecimentoDTO baseConhecimento) throws PersistenceException {
		List<Condition> condition = new ArrayList<>();
		String[] titulo = baseConhecimento.getTitulo().split(" - v[\\d]+.[\\d]+");
		condition.add(new Condition("titulo", Condition.LIKE, ((titulo != null && titulo.length > 0) ? titulo[0] : baseConhecimento.getTitulo()) + "%"));
		List<Order> order = new ArrayList<Order>();
		order.add(new Order("versao"));

		return this.findByCondition(condition, order);
	}
	

	/**
	 * Lista o histrico das bases de conhecimento em que o ttulo contm o parmetro pesquisa
	 * 
	 * @author euler.ramos
	 * @since 03.08.2016
	 * @throws Exception
	 */
	public List<HistoricoBaseConhecimentoDTO> listarHistoricoBaseConhecimentoPorTitulo(String pesquisa) throws PersistenceException {
		List resp = new ArrayList();

		Collection fields = getFields();
		List parametro = new ArrayList();
		List listRetorno = new ArrayList();
		String campos = "";
		for (Iterator it = fields.iterator(); it.hasNext();) {
			Field field = (Field) it.next();
			if (!campos.trim().equalsIgnoreCase("")) {
				campos = campos + ",";
			}

			campos = campos + field.getFieldDB();
			listRetorno.add(field.getFieldClass());
		}

		String sql = "SELECT " + campos + " FROM " + getTableName() + " WHERE lower(titulo) like lower(?) ORDER BY titulo";
		parametro.add("%"+pesquisa+"%");
		resp = this.execSQL(sql, parametro.toArray());

		List result = this.engine.listConvertion(getBean(), resp, listRetorno);
		return result == null ? new ArrayList<HistoricoBaseConhecimentoDTO>() : result;
	}



	/**
	 * Adiciona a consulta SQL sobre o histrico de alteraes em bases de conhecimento ao StringBuilder sql;
	 * 
	 * @author euler.ramos
	 * @since 22.08.2016
	 * @param sql
	 * @param parametro
	 * @param dtInicio
	 * @param dtFim
	 * @param idPasta
	 * @param hierarquizarPasta
	 * @param tipoFiltro
	 * @throws ParseException
	 * @throws LogicException
	 */
	private void completaSqlHistoricoAlteracao(StringBuilder sql, List parametro, final Date dtInicio, final Date dtFim, final Integer idPasta, final String hierarquizarPasta, final Integer tipoFiltro, final UsuarioDTO usuario) throws ParseException, LogicException{
		sql.append("select h.idhistoricobaseconhecimento,h.idbaseconhecimento,h.idpasta,p.nome nomepasta,h.titulo,h.datahoraalteracao,h.versao,h.idusuarioalteracao, usuario.nome nomeusuario,")
		   .append("case when ((h.versao is null) or (h.versao = '1.0')) then 'C' else 'A' end tipo ")
		   .append("from historicobaseconhecimento h ");
		
		//Filtrando somente as pastas que o usurio tem permisso de acesso.
		if ((usuario!=null)&&(usuario.getIdUsuario()!=null)){
			sql.append("join ");
			if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.ORACLE)){
				sql.append("table(");
			}
			sql.append("f_pastas_permitidas(?)");
			
			parametro.add(usuario.getIdUsuario());
			
			if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.ORACLE)){
				sql.append(")");
			}
			sql.append(" pastaspermitidas on h.idpasta = pastaspermitidas.idpasta ");
		}
		
		if ((idPasta!=null)&&(idPasta.intValue()>0)&&(hierarquizarPasta.equalsIgnoreCase("S"))){
			sql.append("join ");
			if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.ORACLE)){
				sql.append("table(");
			}
			sql.append("f_arvore_pastas(?,?,?)");
			parametro.add(idPasta);
			parametro.add(0); //iterao inicial
			parametro.add(1000); //nmero mximo de iteraes, para evitar looping infinito quando h referncias cclicas.
			if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.ORACLE)){
				sql.append(")");
			}
			sql.append(" f ON f.idpasta=h.idpasta ");
		}
		   
		sql.append("join pasta p on h.idpasta = p.idpasta ")
		   .append("left join usuario on usuario.idusuario = h.idusuarioalteracao ")
		   .append("where (h.datahoraalteracao between ? and ?)");
		
		parametro.add(UtilDatas.getSqlDate(dtInicio));
		parametro.add(UtilDatas.getTimeStampComUltimaHoraDoDia(dtFim));
		
		sql.append(" and h.status = 'S'");
		
		if ((idPasta!=null)&&(idPasta.intValue()>0)&&(!hierarquizarPasta.equalsIgnoreCase("S"))){
			sql.append(" and p.idpasta = ?");
			parametro.add(idPasta);
		}
		
		if ((tipoFiltro!=null)&&(tipoFiltro.intValue()>0)){
			if (tipoFiltro.intValue()==1){ 
				//Cadastradas no perodo
				sql.append(" and ((h.versao is null) or (h.versao = '1.0'))");
			} else {
				//Alteradas no perodo
				sql.append(" and ((h.versao is not null) and (h.versao <> '1.0'))");
			}
		}
	}
	
	/**
	 * Lista os histricos de manutenes em bases de conhecimento, de acordo com os filtros informados.
	 * 
	 * @author euler.ramos
	 * @since 22.08.2016
	 * @param dtInicio
	 * @param dtFim
	 * @param idPasta
	 * @param hierarquizarPasta
	 * @param tipoFiltro
	 * @return
	 */
	public ArrayList<HistoricoBaseConhecimentoDTO> listHistoricoBaseConhecimento(final Date dtInicio, final Date dtFim, final Integer idPasta, final String hierarquizarPasta, final Integer tipoFiltro, final UsuarioDTO usuario) {
		List result;
		try {
			List resp = new ArrayList();
            final List parametro = new ArrayList();
            final List listRetorno = new ArrayList();
			
			listRetorno.add("idHistoricoBaseConhecimento");
			listRetorno.add("idBaseConhecimento");
			listRetorno.add("idPasta");
			listRetorno.add("nomePasta");
			listRetorno.add("titulo");
			listRetorno.add("dataHoraAlteracao");
			listRetorno.add("versao");
			listRetorno.add("idUsuarioAlteracao");
			listRetorno.add("nomeUsuario");
			listRetorno.add("tipo");
			
            final StringBuilder sql = new StringBuilder();
            this.completaSqlHistoricoAlteracao(sql, parametro, dtInicio, dtFim, idPasta, hierarquizarPasta, tipoFiltro, usuario);
			sql.append(" order by tipo desc, nomepasta, h.titulo");
			
			resp = this.execSQL(sql.toString(), parametro.toArray());
            result = engine.listConvertion(HistoricoBaseConhecimentoDTO.class, resp, listRetorno);
        } catch (final PersistenceException e) {
			e.printStackTrace();
			result = null;
        } catch (final Exception e) {
			e.printStackTrace();
			result = null;
		}
        return (ArrayList<HistoricoBaseConhecimentoDTO>) (result == null || result.size() <= 0 ? new ArrayList<HistoricoBaseConhecimentoDTO>() : result);
	}

}