package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ImpactoAinDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.SQLConfig;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class ImpactoAinDao extends CrudDaoDefaultImpl {

	public ImpactoAinDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "impactoain";
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idimpactoain", "idImpactoAin", true, true, false, false));
		listFields.add(new Field("impactoain", "impactoAin", false, false, false, false));
		listFields.add(new Field("datahorafim", "dataHoraFim", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<ImpactoAinDTO> getBean() {
		return ImpactoAinDTO.class;
	}

	public boolean verificaSeExiste(String impactoAin) {
		boolean estaCadastrado = false;
		try {
			List param = new ArrayList();
			List list = new ArrayList();
			StringBuilder sql = new StringBuilder();

			sql.append("select impactoain from ").append(getTableName()).append(" where impactoain ");
			if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.POSTGRESQL)) {
				sql.append(" ilike ");
			} else {
				sql.append(" like ");
			}
			sql.append("?");
			param.add(impactoAin);

			sql.append(" and datahorafim is null;");

			list = this.execSQL(sql.toString(), param.toArray());

			if (list != null && !list.isEmpty()) {
				estaCadastrado = true;
			}
		} catch (PersistenceException e) {
			e.printStackTrace();
		}
		return estaCadastrado;
	}

	public ArrayList<ImpactoAinDTO> listaTagsImpacto() {

		ArrayList<ImpactoAinDTO> resultado = new ArrayList<ImpactoAinDTO>();

		try {
			List retorno = new ArrayList();
			final List params = new ArrayList();
			final List fields = new ArrayList();
			fields.add("idimpactoain");
			fields.add("impactoain");

			StringBuilder sql = new StringBuilder();


			sql.append("SELECT idimpactoain, impactoain ");
			sql.append("FROM impactoain ");
			sql.append("WHERE datahorafim IS null");

			retorno = this.execSQL(sql.toString(), params.toArray());

			resultado = (ArrayList<ImpactoAinDTO>) engine.listConvertion(this.getBean(), retorno, fields);
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		return resultado;
	}
}
