package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ImportConfigCamposDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class ImportConfigCamposDao extends CrudDaoDefaultImpl {

	public ImportConfigCamposDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idImportConfigCampo", "idImportConfigCampo", true, true, false, false));
		listFields.add(new Field("idImportConfig", "idImportConfig", false, false, false, false));
		listFields.add(new Field("idimportardados", "idImportarDados", false, false, false, false));
		listFields.add(new Field("origem", "origem", false, false, false, false));
		listFields.add(new Field("destino", "destino", false, false, false, false));
		listFields.add(new Field("script", "script", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return this.getOwner() + "ImportConfigCampos";
	}

	@Override
	public Class<ImportConfigCamposDTO> getBean() {
		return ImportConfigCamposDTO.class;
	}

	@SuppressWarnings("unchecked")
	public Collection<ImportConfigCamposDTO> findByIdImportConfig(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("idImportConfig", "=", parm));
		ordenacao.add(new Order("idImportConfigCampo"));
		return super.findByCondition(condicao, ordenacao);
	}

	public void deleteByIdImportConfig(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idImportConfig", "=", parm));
		super.deleteByCondition(condicao);
	}

	public Collection<?> findByIdImportarDados(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("idImportarDados", "=", parm));
		ordenacao.add(new Order("idImportConfigCampo"));
		return super.findByCondition(condicao, ordenacao);
	}

	/**
	 * Deleta o registro de forma logica, seta o campo dataFim igual a data de execuo
	 *
	 * @param parm
	 * @throws Exception
	 */
	public void deletarLogicamentePorIdImportarDados(Integer parm) throws PersistenceException {
		List<Integer> parametros = new ArrayList<Integer>();

		parametros.add(parm);

		String sql = "UPDATE importconfig SET datafim = {DATAATUAL} WHERE idimportardados = ?";

		super.execUpdate(sql, parametros.toArray());
	}
}