package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.GerenciamentoItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.IndicadorCapacidadeItemConfiguracaoDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.core.DataBase;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.integracao.core.PagingQueryUtil;
import br.com.citframework.util.Constantes;

@SuppressWarnings({"rawtypes","unchecked"})
public class IndicadorCapacidadeItemConfiguracaoDao extends CrudDaoDefaultImpl {
	public IndicadorCapacidadeItemConfiguracaoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idIndicadorCapacidadeIc", "idIndicadorCapacidadeIc", true, true, false, false));
		listFields.add(new Field("idIndicadorCapacidade", "idIndicadorCapacidade", false, false, false, false));
		listFields.add(new Field("idItemConfiguracao", "idItemConfiguracao", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return "INDICADORESCAPACIDADEIC";
	}

	@Override
	public Class<IndicadorCapacidadeItemConfiguracaoDTO> getBean() {
		return IndicadorCapacidadeItemConfiguracaoDTO.class;
	}
	
	public List<IndicadorCapacidadeItemConfiguracaoDTO> listByIdItemConfiguracao(GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO, Integer pageNo, Integer pageSize) throws Exception {
		
		List<Object> parametros = new ArrayList<>();
		
		String query = getQueryListByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao(), parametros);
		
		Pageable pageable = new PageRequest(pageNo, pageSize);
		
		query = PagingQueryUtil.concatPagingPieceOnQuery(pageable, query, DataBase.fromStringId(CITCorporeUtil.SGBD_PRINCIPAL));
		
		List retorno = this.execSQL(query, parametros.toArray());
		
		List fields = new ArrayList<>();
		fields.addAll(getFields());
		fields.add("nome");
		fields.add("valor");
		
		if(retorno != null)
			return this.listConvertion(getBean(), retorno, fields);
		return null;
	}
	
	public Integer getTotalItensAtributosFinanceiros(Integer idItemConfiguracao) throws Exception{
		List<Object> parametros = new ArrayList<>();
		
		List retorno = this.execSQL(getQueryListByIdItemConfiguracao(idItemConfiguracao, parametros), parametros.toArray());
		
		return retorno.size();
	}

	private String getQueryListByIdItemConfiguracao(Integer itemConfiguracao, List<Object> parametros) throws Exception{
		StringBuilder sb = new StringBuilder();
		
		sb.append("SELECT ").append(getNamesFieldsStr("indcapic"));
		sb.append(" ,indcap.nome ");
		sb.append(" ,indcap.valor ");
		sb.append("FROM ").append(getTableName()).append(" indcapic ");
		sb.append(" INNER JOIN INDICADORCAPACIDADE indcap ON indcap.idindicadorcapacidade = indcapic.idindicadorcapacidade AND indcap.datahorafim IS NULL ");
		sb.append(" AND indcapic.iditemconfiguracao = ? ");
		sb.append("ORDER BY indcap.nome ");
		parametros.add(itemConfiguracao);
		
		return sb.toString();
	}
	
	public void deleteByIdServico(Integer idItemConfiguracao) throws Exception {
		List<Condition> condition = new ArrayList<>();
		condition.add(new Condition("idItemConfiguracao", Condition.EQUALS, idItemConfiguracao));
		super.deleteByCondition(condition);
	}
	
	public List<IndicadorCapacidadeItemConfiguracaoDTO> listAllByIdServico(Integer idItemConfiguracao) throws Exception {
		List<Object> parametros = new ArrayList<>();
		
		String query = getQueryListByIdItemConfiguracao(idItemConfiguracao, parametros);
		
		List retorno = this.execSQL(query, parametros.toArray());
		
		List fields = new ArrayList<>();
		fields.addAll(getFields());
		fields.add("nome");
		fields.add("valor");
		
		if(retorno != null)
			return this.listConvertion(getBean(), retorno, fields);
		return null;
	}
}
