package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.InvocacaoDTO;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class InvocacaoDAO extends CrudDaoDefaultImpl {

	public InvocacaoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "invocacao";
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idInvocacao", "idInvocacao", true, true, false, false));
		listFields.add(new Field("idContinuidade", "idContinuidade", false, false, false, false));
		listFields.add(new Field("idCliente", "idCliente", false, false, false, false));
		listFields.add(new Field("idSolicitacaoRelacionado", "idSolicitacaoRelacionado", false, false, false, false));
		listFields.add(new Field("idSolicitacao", "idSolicitacao", false, false, false, false));
		listFields.add(new Field("nomeServico", "nomeServico", false, false, false, false));
		listFields.add(new Field("idGrupoAprovador", "idGrupoAprovador", false, false, false, false));
		listFields.add(new Field("idGrupoExecutor", "idGrupoExecutor", false, false, false, false));
		listFields.add(new Field("idResponsavel", "idResponsavel", false, false, false, false));
		listFields.add(new Field("idStatus", "idStatus", false, false, false, false));
		return listFields;
	}

	@SuppressWarnings("unchecked")
	public void createInvocacao(final Integer idContinuidade, final Integer idSolicitacaoProcedimento) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append(" SELECT ");
		sqlBuilder.append(" 	solicitacaoServico.idSolicitacaoRelacionada, ");
		sqlBuilder.append(" 	solicitacaoServico.idSolicitacaoServico, ");
		sqlBuilder.append(" 	servico.nomeServico, ");
		sqlBuilder.append(" 	servicoContrato.idGrupoAprovador, ");
		sqlBuilder.append(" 	servicoContrato.idGrupoExecutor, ");
		sqlBuilder.append(" 	solicitacaoServico.idStatus ");
		sqlBuilder.append(" FROM ");
		sqlBuilder.append(" 	solicitacaoServico solicitacaoServico ");
		sqlBuilder.append(" 	INNER JOIN servicoContrato servicoContrato ");
		sqlBuilder.append("			ON solicitacaoServico.idServicoContrato = servicoContrato.idServicoContrato ");
		sqlBuilder.append(" 	INNER JOIN servico servico ");
		sqlBuilder.append("			ON servicoContrato.idServico = servico.idServico ");
		sqlBuilder.append(" WHERE ");
		sqlBuilder.append(" 	idSolicitacaoServico = ? ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idSolicitacaoProcedimento);

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idSolicitacaoRelacionado");
		listRetorno.add("idSolicitacao");
		listRetorno.add("nomeServico");
		listRetorno.add("idGrupoAprovador");
		listRetorno.add("idGrupoExecutor");
		listRetorno.add("idStatus");

		List<InvocacaoDTO> listInvocacao = this.engine.listConvertion(InvocacaoDTO.class, listResultado, listRetorno);

		if (listInvocacao != null && !listInvocacao.isEmpty()) {
			InvocacaoDTO invocacaoDTO = listInvocacao.iterator().next();
			invocacaoDTO.setIdContinuidade(idContinuidade);
			this.create(invocacaoDTO);
		}
	}

	@Override
	public Class<InvocacaoDTO> getBean() {
		return InvocacaoDTO.class;
	}

}
