package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ItemConfiguracaoAcordoNivelServicoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class ItemConfiguracaoAcordoNivelServicoDao extends CrudDaoDefaultImpl {

	public ItemConfiguracaoAcordoNivelServicoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {

		Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idItemConfiguracao", "idItemConfiguracao", true, false, false, false));
		listFields.add(new Field("idAcordoNivelServico", "idAcordoNivelServico", true, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "ICCACORDONIVELSERVICO";
	}

	@Override
	public Class getBean() {
		return ItemConfiguracaoAcordoNivelServicoDTO.class;
	}

	public void deleteByIdAcordoNivelServico(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idAcordoNivelServico", "=", parm));
		super.deleteByCondition(condicao);
	}

	public void deleteByIdItemConfiguracao(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idItemConfiguracao", "=", parm));
		super.deleteByCondition(condicao);
	}

	public Collection findByIdAcordoNivelServico(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idAcordoNivelServico", "=", parm));
		return super.findByCondition(condicao, ordenacao);
	}

	public Collection findByIdItemConfiguracao(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idItemConfiguracao", "=", parm));
		return super.findByCondition(condicao, ordenacao);
	}

}
