package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ItemConfiguracaoValorDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.integracao.core.DataBase;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.integracao.core.PagingQueryUtil;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;

@SuppressWarnings({"rawtypes", "unchecked"})
public class ItemConfiguracaoValorDao extends CrudDaoDefaultImpl {

	public ItemConfiguracaoValorDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	
	@Override
	public String getTableName() {
		return "ITEMCONFIGURACAOVALOR";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> fields = new ArrayList<>();
		fields.add(new Field("idItemConfiguracaoValor", "idItemConfiguracaoValor", true, true, false, true));
		fields.add(new Field("idItemConfiguracao", "idItemConfiguracao", false, false, false, false));
		fields.add(new Field("dataInicioValor", "dataInicioValor", false, false, false, false));
		fields.add(new Field("dataFimValor", "dataFimValor", false, false, false, false));
		fields.add(new Field("dataFim", "dataFim", false, false, false, false));
		fields.add(new Field("valor", "valor", false, false, false, false));
		return fields;
	}

	@Override
	public Class getBean() {
		return ItemConfiguracaoValorDTO.class;
	}
	
	@Override
	public void delete(IDto obj) throws PersistenceException {
		ItemConfiguracaoValorDTO itemConfiguracaoValorDTO = (ItemConfiguracaoValorDTO) obj;
		itemConfiguracaoValorDTO.setDataFim(UtilDatas.getDataAtual());
		super.update(obj);
	}
	
	public Collection listByIdItemConfiguracao(ItemConfiguracaoValorDTO itemConfiguracaoValorDTO) throws Exception {
		List<Condition> condition = new ArrayList<>();
		condition.add(new Condition("dataFim", Condition.IS, null));
		condition.add(new Condition("idItemConfiguracao", Condition.EQUALS, itemConfiguracaoValorDTO.getIdItemConfiguracao()));
		return super.findByCondition(condition, new ArrayList<Order>());	
	}
	
	public List<ItemConfiguracaoValorDTO> listByIdItemConfiguracaoPaginado(ItemConfiguracaoValorDTO itemConfiguracaoValorDTO) throws Exception {
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();
		sql.append("SELECT ").append(getNamesFieldsStr()).append(" FROM ").append(getTableName());
		sql.append(" WHERE IDITEMCONFIGURACAO = ?");
		parametros.add(itemConfiguracaoValorDTO.getIdItemConfiguracao());
		sql.append(" AND DATAFIM IS NULL ");
		sql.append("  ORDER BY DATAINICIOVALOR ");
		Pageable pageable = new PageRequest(itemConfiguracaoValorDTO.getPageNo(), itemConfiguracaoValorDTO.getPageSize());
		String query = PagingQueryUtil.concatPagingPieceOnQuery(pageable, sql.toString(), DataBase.fromStringId(CITCorporeUtil.SGBD_PRINCIPAL));
		
		List result = this.execSQL(query, parametros.toArray());
		
		return this.listConvertion(getBean(), result, new ArrayList<>(getFields()));
	}
	
}
