package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.KpiObjetivoMonitoramentoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

@SuppressWarnings({ "unchecked", "unused", "rawtypes" })
public class KpiObjetivoMonitoramentoDao extends CrudDaoDefaultImpl {

	public KpiObjetivoMonitoramentoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idkpiobjetivomonitoramento", "idKpiObjetivoMonitoramento", true, true, false, false));
		listFields.add(new Field("idobjetivomonitoramento", "idObjetivoMonitoramento", false, false, false, false));
		listFields.add(new Field("kpi", "kpi", false, false, false, false));
		listFields.add(new Field("criadopor", "criadoPor", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return this.getOwner() + "kpiobjetivomonitoramento";
	}

	@Override
	public Collection list() throws PersistenceException {
		return null;
	}

	@Override
	public Class getBean() {
		return KpiObjetivoMonitoramentoDTO.class;
	}

	@Override
	public Collection find(IDto arg0) throws PersistenceException {
		return null;
	}

	public Collection findByIdObjetivosMonitoramento(Integer id) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idobjetivomonitoramento", "=", id));
		ordenacao.add(new Order("kpi"));
		return super.findByCondition(condicao, ordenacao);
	}

	public void deleteByIdKpiObjetivosMonitoramento(Integer id) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idKpiObjetivoMonitoramento", "=", id));
		super.deleteByCondition(condicao);
	}

	@Override
	public void update(IDto obj) throws PersistenceException {
		KpiObjetivoMonitoramentoDTO dto = (KpiObjetivoMonitoramentoDTO) restore(obj);
		String criadoPor = ((KpiObjetivoMonitoramentoDTO) obj).getCriadoPor();

		if (dto != null && criadoPor != null) {
			dto.setCriadoPor(criadoPor);
		}

		super.update(dto);
	}

	public List<KpiObjetivoMonitoramentoDTO> listKpiObjetivosMonitoramento(Integer idobjetivomonitoramento) throws PersistenceException {

		if (idobjetivomonitoramento != null) {
			StringBuilder sql = new StringBuilder();
			List parametro = new ArrayList();
			List list = new ArrayList();

			sql.append("select * from " + getTableName() + " where idobjetivomonitoramento = ? ");
			parametro.add(idobjetivomonitoramento);

			list = this.execSQL(sql.toString(), parametro.toArray());
			List<String> listaRetorno = new ArrayList();

			listaRetorno.add("idKpiObjetivoMonitoramento");
			listaRetorno.add("idObjetivoMonitoramento");
			listaRetorno.add("kpi");
			listaRetorno.add("criadoPor");

			if (list != null && !list.isEmpty()) {
				return this.listConvertion(KpiObjetivoMonitoramentoDTO.class, list, listaRetorno);
			}
		}

		return null;
	}

	public List<IDto> listKpiObjetivosMonitoramentoAsDTO(Integer idobjetivomonitoramento) throws PersistenceException {
		List<IDto> listIdto = new ArrayList<>();
		Collection<KpiObjetivoMonitoramentoDTO> list = listKpiObjetivosMonitoramento(idobjetivomonitoramento);

		if (list != null) {
			listIdto.addAll(list);
		}

		return listIdto;
	}

	public Boolean hasKpi(Integer idObjetivoMonitoramento) throws PersistenceException {
		return listKpiObjetivosMonitoramento(idObjetivoMonitoramento) != null ? listKpiObjetivosMonitoramento(idObjetivoMonitoramento).size() > 0 : false;
	}

	public String getKpis(Integer idObjetivoMonitoramento) throws PersistenceException {
		StringBuilder stringBuilder = new StringBuilder("");
		List<KpiObjetivoMonitoramentoDTO> retornoDoBanco = listKpiObjetivosMonitoramento(idObjetivoMonitoramento);
		if (retornoDoBanco != null) {
			for (int i = 0; i < retornoDoBanco.size(); i++) {
				if (retornoDoBanco.get(i) != null) {
					String kpi = retornoDoBanco.get(i).getKpi();

					if (kpi != null && kpi != null && kpi.length() > 0) {
						stringBuilder.append(kpi);

						// No adiciona a vrgugla no ltimo caso
						if (i != retornoDoBanco.size() - 1) {
							stringBuilder.append(", ");
						}
					}
				}
			}
		}
		return stringBuilder.toString();
	}

}
