package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.LiberacaoBaseConhecimentoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

@SuppressWarnings({ "unchecked", "rawtypes" })
public class LiberacaoBaseConhecimentoDao extends CrudDaoDefaultImpl {

	public LiberacaoBaseConhecimentoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}
	
	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idliberacao" ,"idLiberacao", false, false, false, false));
		listFields.add(new Field("idbaseconhecimento" ,"idBaseConhecimento", true, false, false, false));
		return listFields;
	}
	@Override
	public String getTableName() {
		return this.getOwner() + "LiberacaoBaseConhecimento";
	}
	@Override
	public Collection list() throws PersistenceException {
		return null;
	}

	@Override
	public Class getBean() {
		return LiberacaoBaseConhecimentoDTO.class;
	}
	@Override
	public Collection find(IDto arg0) throws PersistenceException {
		return null;
	}

	public Collection findByIdLiberacao(Integer idLiberacao) throws Exception {
		List list;
		List parametro = new ArrayList();
		List fields = new ArrayList();
		StringBuffer sql = new StringBuffer();
		sql.append(" SELECT bc.idBaseConhecimento, bc.titulo FROM liberacaobaseconhecimento lbc ")
		.append(" JOIN historicobaseconhecimento bc ON lbc.idbaseconhecimento = bc.idbaseconhecimento WHERE lbc.idliberacao = ? ORDER BY lbc.idbaseconhecimento");
		parametro.add(idLiberacao);
		list = this.execSQL(sql.toString(), parametro.toArray());
		fields.add("idBaseConhecimento");
		fields.add("titulo");
		if (list != null && !list.isEmpty()) {
			return this.listConvertion(getBean(), list, fields);
		} else {
			return null;
		}
	}
	
	public void deleteByIdLiberacao(Integer parm) throws Exception {
		List condicao = new ArrayList();
		condicao.add(new Condition("idLiberacao", "=", parm));
		super.deleteByCondition(condicao);
	}

	public ArrayList<LiberacaoBaseConhecimentoDTO> listByIdRequisicaoLiberacao(Integer idrequisicaoliberacao) throws ServiceException, Exception {
		ArrayList<Condition> condicoes = new ArrayList<Condition>();
		condicoes.add(new Condition("idLiberacao", "=", idrequisicaoliberacao));
		return (ArrayList<LiberacaoBaseConhecimentoDTO>) super.findByCondition(condicoes, null);
	}
	
	public void deleteByIdBaseConhecimento(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idBaseConhecimento", "=", parm));
		super.deleteByCondition(condicao);
	}

}