package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.LiberacaoMudancaDTO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class LiberacaoMudancaDao extends CrudDaoDefaultImpl {


	public LiberacaoMudancaDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	private static final String SQL_DELETE =
	          "delete from  liberacaomudanca where idliberacao = ? and idhistoricoliberacao is null";
	private static final String SQL_DELETE_BY_ID_MUDANCA =
	          "delete from  liberacaomudanca where idRequisicaoMudanca = ? and idhistoricomudanca is null ";

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idLiberacao" ,"idLiberacao", false, false, false, false));
		listFields.add(new Field("idRequisicaoMudanca" ,"idRequisicaoMudanca", true, false, false, false));
		listFields.add(new Field("idhistoricoliberacao" ,"idHistoricoLiberacao", true, false, false, false));
		listFields.add(new Field("idReleaseStatus", "idReleaseStatus", false, false, false, false));
		listFields.add(new Field("idHistoricoMudanca" ,"idHistoricoMudanca", false, false, false, false));
		return listFields;
	}
	@Override
	public String getTableName() {
		return this.getOwner() + "liberacaomudanca";
	}

	@Override
	public Class<LiberacaoMudancaDTO> getBean() {
		return LiberacaoMudancaDTO.class;
	}

	public Collection findByIdLiberacao(Integer parm) throws Exception {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idLiberacao", parm));
		condicao.add(new Condition("idHistoricoLiberacao", Condition.IS, null));

		List<Order> ordenacao = new ArrayList<Order>();
		ordenacao.add(new Order("idRequisicaoMudanca"));

		return super.findByCondition(condicao, ordenacao);
	}
	public void deleteByIdLiberacao(Integer parm) throws Exception {
		 super.execUpdate(SQL_DELETE, new Object[]{parm});
	}

	public ArrayList<LiberacaoMudancaDTO> listByIdRequisicaoLiberacao(Integer idrequisicaoliberacao) throws ServiceException, Exception {
		ArrayList<Condition> condicoes = new ArrayList<Condition>();
		condicoes.add(new Condition("idLiberacao", idrequisicaoliberacao));

		return (ArrayList<LiberacaoMudancaDTO>) super.findByCondition(condicoes, null);
	}

	public ArrayList<LiberacaoMudancaDTO> listByIdRequisicaMudanca(Integer idrequisicaoMudanca) throws ServiceException, Exception {
		ArrayList<Condition> condicoes = new ArrayList<Condition>();
		condicoes.add(new Condition("idRequisicaoMudanca", idrequisicaoMudanca));

		return (ArrayList<LiberacaoMudancaDTO>) super.findByCondition(condicoes, null);
	}

	public ArrayList<LiberacaoMudancaDTO> listByIdHistoricoLiberacao(Integer idHistoricoLiberacao) throws ServiceException, Exception {
		ArrayList<Condition> condicoes = new ArrayList<Condition>();
		condicoes.add(new Condition("idHistoricoLiberacao", idHistoricoLiberacao));

		return (ArrayList<LiberacaoMudancaDTO>) super.findByCondition(condicoes, null);
	}

	public ArrayList<LiberacaoMudancaDTO> listByIdHistoricoMudanca(Integer idHistoricoMudanca) throws ServiceException, Exception {
		ArrayList<Condition> condicoes = new ArrayList<Condition>();
		condicoes.add(new Condition("idHistoricoMudanca", idHistoricoMudanca));

		return (ArrayList<LiberacaoMudancaDTO>) super.findByCondition(condicoes, null);
	}

	public Collection<LiberacaoMudancaDTO> findByIdRequisicaoMudanca(Integer idLiberacao, Integer idRequisicaoMudanca) throws Exception {
		List<Integer> parametro = new ArrayList<Integer>();
		List<String> fields = new ArrayList<String>();
		List<?> list = new ArrayList<Object>();
		StringBuilder sql =  new StringBuilder();
		sql.append(" SELECT libmud.idliberacao,libmud.idrequisicaomudanca, lib.titulo, lib.descricao, libmud.status, libmud.idReleaseStatus  ");
		sql.append(" FROM liberacaomudanca libmud  ");
		sql.append(" inner join liberacao lib on libmud.idliberacao = lib.idliberacao ");
		sql.append(" inner join requisicaomudanca mud on libmud.idrequisicaomudanca = mud.idrequisicaomudanca  where idhistoricoliberacao is null and idhistoricomudanca is null and ");

		if(idRequisicaoMudanca != null){
			if(idLiberacao != null){
				sql.append(" libmud.idrequisicaomudanca = ? AND ");
			}else{
				sql.append(" libmud.idrequisicaomudanca = ? ");
			}
			parametro.add(idRequisicaoMudanca);
		}

		if(idLiberacao != null){
			sql.append(" libmud.idliberacao  = ? ");
			parametro.add(idLiberacao);
		}

		list = this.execSQL(sql.toString(), parametro.toArray());
		fields.add("idLiberacao");
		fields.add("idRequisicaoMudanca");
		fields.add("titulo");
		fields.add("descricao");
		fields.add("status");
		fields.add("idReleaseStatus");
		if (list != null && !list.isEmpty()) {
			return this.listConvertion(getBean(), list, fields);
		} else {
			return null;
		}
	}

	public Collection<LiberacaoMudancaDTO> listByIdHistoricoMudanca2(Integer idHistoricoMudanca) throws Exception {
		List<Integer> parametro = new ArrayList<Integer>();
		List<String> fields = new ArrayList<String>();
		List<?> list = new ArrayList<Object>();
		StringBuilder sql = new StringBuilder();
		sql.append("SELECT libmud.idliberacao,libmud.idrequisicaomudanca, lib.titulo, lib.descricao, libmud.status, libmud.idReleaseStatus " + "FROM liberacaomudanca libmud  "
				+ "inner join liberacao lib on libmud.idliberacao = lib.idliberacao " + "inner join requisicaomudanca mud on libmud.idrequisicaomudanca = mud.idrequisicaomudanca " + "where idhistoricomudanca = ?   ");

		parametro.add(idHistoricoMudanca);

		list = this.execSQL(sql.toString(), parametro.toArray());
		fields.add("idLiberacao");
		fields.add("idRequisicaoMudanca");
		fields.add("titulo");
		fields.add("descricao");
		fields.add("status");
		fields.add("idReleaseStatus");
		if (list != null && !list.isEmpty()) {
			return this.listConvertion(getBean(), list, fields);
		} else {
			return null;
		}
	}

	public Collection<LiberacaoMudancaDTO> findByIdLiberacao2(Integer parm) throws Exception {
		List<Integer> parametro = new ArrayList<Integer>();
		List<String> fields = new ArrayList<String>();
		List<?> list = new ArrayList<Object>();
		StringBuilder sql =  new StringBuilder();
		sql.append(" select libm.idliberacao, l.titulo, l.descricao, libm.status, libm.idReleaseStatus, libm.idrequisicaomudanca  from liberacaomudanca libm  ");
		sql.append(" inner join liberacao l on  l.idliberacao = libm.idliberacao ");
		sql.append(" where libm.idliberacao = ? and idhistoricoliberacao is null");
		parametro.add(parm);
		list = this.execSQL(sql.toString(), parametro.toArray());
		fields.add("idLiberacao");
		fields.add("titulo");
		fields.add("descricao");
		fields.add("status");
		fields.add("idReleaseStatus");
		fields.add("idRequisicaoMudanca");
		if (list != null && !list.isEmpty()) {
			return this.listConvertion(getBean(), list, fields);
		} else {
			return null;
		}
	}

	public void deleteByIdRequisicaoMudanca(Integer idRequisicaoMudanca) throws ServiceException, Exception{
		ArrayList<Condition> condicoes = new ArrayList<Condition>();
		condicoes.add(new Condition("idRequisicaoMudanca", idRequisicaoMudanca));
		super.deleteByCondition(condicoes);
	}

	public void deleteByIdMudanca(Integer parm) throws Exception {
		 super.execUpdate(SQL_DELETE_BY_ID_MUDANCA, new Object[]{parm});
	}

}
