package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.LiberacaoSolicitacaoServicoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;

public class LiberacaoSolicitacaoServicoDAO extends CrudDaoDefaultImpl {
	
	public LiberacaoSolicitacaoServicoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}
	
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idliberacaosolicitacaoservico", "idLiberacaoSolicitacaoServico", true, true, false, false));
		listFields.add(new Field("idliberacao" ,"idLiberacao", false, false, false, false));
		listFields.add(new Field("idsolicitacaoservico", "idSolicitacaoServico", false, false, false, false));
		listFields.add(new Field("datafim", "dataFim", false, false, false, false));
		return listFields;
	}
	
	public String getTableName() {
		return this.getOwner() + "liberacaosolicitacaoservico";
	}
	@SuppressWarnings("rawtypes")
	public Collection list() throws PersistenceException {
		return null;
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public Class getBean() {
		return LiberacaoSolicitacaoServicoDTO.class;
	}
	
	@SuppressWarnings("rawtypes")
	public Collection find(IDto arg0) throws PersistenceException {
		return null;
	}
	
	private String corpoSQLByIdSolicitacaoServico(){
        StringBuilder sql = new StringBuilder();
        sql.append("from ").append(getTableName()).append(" where (idsolicitacaoservico=?) and (datafim is null)");
        return sql.toString();
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public void deleteByIdRequisicaoLiberacao(Integer idRequisicaoLiberacao) throws ServiceException, Exception{
		List parametros = new ArrayList();
		if (idRequisicaoLiberacao != null) {
			parametros.add(UtilDatas.getDataAtual());
			parametros.add(idRequisicaoLiberacao);
			
			String sql = "UPDATE " + getTableName() + " SET datafim = ? WHERE idliberacao = ?";
			execUpdate(sql, parametros.toArray());
		}
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public void deleteByIdSolicitacaoServico(Integer idSolicitacaoServico) throws ServiceException, Exception{
		List parametros = new ArrayList();
		if (idSolicitacaoServico != null) {
			parametros.add(UtilDatas.getDataAtual());
			parametros.add(idSolicitacaoServico);
			
			String sql = "UPDATE " + getTableName() + " SET datafim = ? WHERE idsolicitacaoservico = ?";
			execUpdate(sql, parametros.toArray());
		}
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public Collection<LiberacaoSolicitacaoServicoDTO> findByIdRequisicaoLiberacao(Integer idRequisicaoLiberacao) {
        List result;
        try {
            List resp = new ArrayList();
            List parametro = new ArrayList();
            List listRetorno = new ArrayList();

            listRetorno.add("idLiberacaoSolicitacaoServico");
            listRetorno.add("idLiberacao");
            listRetorno.add("idSolicitacaoServico");
            listRetorno.add("dataFim");
            
            StringBuilder sql = new StringBuilder();
            sql.append("select * ");
            sql.append("from ").append(getTableName()).append(" where (idliberacao=?) and (datafim is null)");
            
			parametro.add(idRequisicaoLiberacao);
            
			resp = this.execSQL(sql.toString(), parametro.toArray());

            result = engine.listConvertion(getBean(), resp, listRetorno);
        } catch (PersistenceException e) {
            e.printStackTrace();
            result = null;
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return (((result == null)||(result.size()<=0)) ? new ArrayList<LiberacaoSolicitacaoServicoDTO>() : result);
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public Collection<LiberacaoSolicitacaoServicoDTO> findByIdSolicitacaoServico(Integer idSolicitacaoServico) {
        List result;
        try {
            List resp = new ArrayList();
            List parametro = new ArrayList();
            List listRetorno = new ArrayList();

            listRetorno.add("idLiberacaoSolicitacaoServico");
            listRetorno.add("idLiberacao");
            listRetorno.add("idSolicitacaoServico");
            listRetorno.add("dataFim");
            
            StringBuilder sql = new StringBuilder();
            sql.append("select * ").append(this.corpoSQLByIdSolicitacaoServico());
            
			parametro.add(idSolicitacaoServico);
            
			resp = this.execSQL(sql.toString(), parametro.toArray());

            result = engine.listConvertion(getBean(), resp, listRetorno);
        } catch (PersistenceException e) {
            e.printStackTrace();
            result = null;
        } catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return (((result == null)||(result.size()<=0)) ? new ArrayList<LiberacaoSolicitacaoServicoDTO>() : result);
	}

}