package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.MapaDesenhoCatalogoNegocioImagemDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

/**
 * @author rodrigo.guilherme
 * 
 */
@SuppressWarnings({ "rawtypes", "unchecked" })
public class MapaDesenhoCatalogoNegocioImagemDao extends CrudDaoDefaultImpl {

	public MapaDesenhoCatalogoNegocioImagemDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<MapaDesenhoCatalogoNegocioImagemDTO> find(final IDto obj) {
		return null;
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idcatalogonegociomapaimg", "idCatalogoNegocioMapaImg", true, true, false, false));
		listFields.add(new Field("idcatalogonegocio", "idCatalogoNegocio", false, false, false, false));
		listFields.add(new Field("idservico", "idServico", false, false, false, false));
		listFields.add(new Field("posx", "posx", false, false, false, false));
		listFields.add(new Field("posy", "posy", false, false, false, false));
		listFields.add(new Field("descricao", "descricao", false, false, false, false));
		listFields.add(new Field("caminhoimagem", "caminhoImagem", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return "catalogonegociomapaimg";
	}

	/**
	 * Retorna lista de imagens a partir do id do processo de negcio
	 *
	 * @param Integer
	 * @return Collection<MapaDesenhoProcessoNegocioImagemDTO>
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 15.07.2015
	 */
	public Collection<MapaDesenhoCatalogoNegocioImagemDTO> findByIdCatalogoNegocio(Integer idCatalogoNegocio) throws Exception {
		Collection<MapaDesenhoCatalogoNegocioImagemDTO> listProcessoNegocioImagemDto = new ArrayList<>();

		final List<Condition> condicao = new ArrayList<>();

		condicao.add(new Condition("idCatalogoNegocio", "=", idCatalogoNegocio));

		listProcessoNegocioImagemDto = this.findByCondition(condicao, null);

		return listProcessoNegocioImagemDto;
	}

	@Override
	public Class getBean() {
		return MapaDesenhoCatalogoNegocioImagemDTO.class;
	}

}
