package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.MapaDesenhoCatalogoNegocioImagemDTO;
import br.com.centralit.citcorpore.bean.MapaDesenhoCatalogoNegocioImagemRelacaoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class MapaDesenhoCatalogoNegocioImagemRelacaoDao extends CrudDaoDefaultImpl {

	public MapaDesenhoCatalogoNegocioImagemRelacaoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}
	
	@SuppressWarnings("rawtypes")
	@Override
	public Collection find(IDto obj) throws PersistenceException {
		return null;
	}
	
	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idcatnegmapaimgrel", "idCatalogoNegocioMapaImgRel", true, true, false, false));
		listFields.add(new Field("idcatnegmapaimgfilho", "idCatalogoNegocioMapaImgFilho", false, false, false, false));
		listFields.add(new Field("idcatnegmapaimgpai", "idCatalogoNegocioMapaImgPai", false, false, false, false));
		return listFields;
	}
	@Override
	public String getTableName() {
		return "catalogonegociomapaimgrelacao";
	}
	
	/**
	 * Retorna as relaes(ligaes) de imagens a partir do id filho
	 *
	 * @param MapaDesenhoCatalogoNegocioImagemDTO
	 * @return Collection<MapaDesenhoProcessoNegocioImagemRelacaoDTO>
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 17.07.2015
	 */
	@SuppressWarnings("unchecked")
	public Collection<MapaDesenhoCatalogoNegocioImagemRelacaoDTO> findByIdCatalogoNegocioMapaImgFilho(MapaDesenhoCatalogoNegocioImagemDTO mapaDesenhoProcessoNegocioImagemDTO) throws Exception {
		Collection<MapaDesenhoCatalogoNegocioImagemRelacaoDTO> listProcessoNegocioImagemRelacaoDto = new ArrayList<>();

		if (mapaDesenhoProcessoNegocioImagemDTO != null && mapaDesenhoProcessoNegocioImagemDTO.getIdCatalogoNegocioMapaImg() != null) {
			final List<Condition> condicao = new ArrayList<>();

			condicao.add(new Condition("idCatalogoNegocioMapaImgFilho", "=", mapaDesenhoProcessoNegocioImagemDTO.getIdCatalogoNegocioMapaImg()));

			listProcessoNegocioImagemRelacaoDto = this.findByCondition(condicao, null);
		}

		return listProcessoNegocioImagemRelacaoDto;
	}

	/**
	 * Retorna a ligao de duas imagens a partir dos ids do seu pai e do
	 * seufilho
	 *
	 * @param MapaDesenhoCatalogoNegocioImagemRelacaoDTO
	 * @return MapaDesenhoProcessoNegocioImagemRelacaoDTO
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 17.07.2015
	 */
	@SuppressWarnings("unchecked")
	public MapaDesenhoCatalogoNegocioImagemRelacaoDTO findByIdCatalogoNegocioMapaImgFilhoAndIdImgPai(MapaDesenhoCatalogoNegocioImagemRelacaoDTO imagemRelacaoDTO) throws Exception {
		Collection<MapaDesenhoCatalogoNegocioImagemRelacaoDTO> listProcessoNegocioImagemRelacaoDto = new ArrayList<>();

		if (imagemRelacaoDTO != null && imagemRelacaoDTO.getIdCatalogoNegocioMapaImgPai() != null && imagemRelacaoDTO.getIdCatalogoNegocioMapaImgFilho() != null) {
			final List<Condition> condicao = new ArrayList<>();

			condicao.add(new Condition("idCatalogoNegocioMapaImgPai", "=", imagemRelacaoDTO.getIdCatalogoNegocioMapaImgPai()));
			condicao.add(new Condition("idCatalogoNegocioMapaImgFilho", "=", imagemRelacaoDTO.getIdCatalogoNegocioMapaImgFilho()));

			listProcessoNegocioImagemRelacaoDto = this.findByCondition(condicao, null);
		}
		
		if (listProcessoNegocioImagemRelacaoDto != null && listProcessoNegocioImagemRelacaoDto.size() > 0) {
			for(MapaDesenhoCatalogoNegocioImagemRelacaoDTO relacaoDto : listProcessoNegocioImagemRelacaoDto){
				//retorna o primeiro da lista
				return relacaoDto;
			}
		}

		return null;
	}

	/**
	 * Antes de remover a imagem de processo de negcio, deletar todas as
	 * ligaes que ela era pai.
	 *
	 * @param mapaDesenhoProcessoNegocioImagemDTO
	 * @return int
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 17.07.2015
	 */
	public int deleteRelacaoByIdPai(MapaDesenhoCatalogoNegocioImagemDTO mapaDesenhoProcessoNegocioImagemDTO) throws Exception {
		int retornoRemocao = 0;

		if (mapaDesenhoProcessoNegocioImagemDTO != null && mapaDesenhoProcessoNegocioImagemDTO.getIdCatalogoNegocioMapaImg() != null) {
			final List<Condition> condicaoImgPai = new ArrayList<>();

			condicaoImgPai.add(new Condition("idCatalogoNegocioMapaImgPai", "=", mapaDesenhoProcessoNegocioImagemDTO.getIdCatalogoNegocioMapaImg()));

			retornoRemocao = this.deleteByCondition(condicaoImgPai);
		}

		return retornoRemocao;
	}

	/**
	 * Antes de remover a imagem de processo de negcio, deletar todas as
	 * ligaes que ela era filho.
	 *
	 * @param mapaDesenhoProcessoNegocioImagemDTO
	 * @return int
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 17.07.2015
	 */
	public int deleteRelacaoByIdFilho(MapaDesenhoCatalogoNegocioImagemDTO mapaDesenhoProcessoNegocioImagemDTO) throws Exception {
		int retornoRemocao = 0;

		if (mapaDesenhoProcessoNegocioImagemDTO != null && mapaDesenhoProcessoNegocioImagemDTO.getIdCatalogoNegocioMapaImg() != null) {
			final List<Condition> condicaoImgFilho = new ArrayList<>();

			condicaoImgFilho.add(new Condition("idCatalogoNegocioMapaImgFilho", "=", mapaDesenhoProcessoNegocioImagemDTO.getIdCatalogoNegocioMapaImg()));

			retornoRemocao = this.deleteByCondition(condicaoImgFilho);
		}

		return retornoRemocao;
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	public Class getBean() {
		return MapaDesenhoCatalogoNegocioImagemRelacaoDTO.class;
	}

}
