package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.MapaNegocioItemDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

/**
 * @author rodrigo.guilherme
 * 
 */
@SuppressWarnings({ "rawtypes", "unchecked" })
public class MapaNegocioItemDao extends CrudDaoDefaultImpl {

	public MapaNegocioItemDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<MapaNegocioItemDTO> find(final IDto obj) {
		return null;
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idmapanegocioitem", "idMapaNegocioItem", true, true, false, false));
		listFields.add(new Field("idserviconegocio", "idServicoNegocio", false, false, false, false));
		listFields.add(new Field("idservicoapoio", "idServicoApoio", false, false, false, false));
		listFields.add(new Field("iditemconfiguracao", "idItemConfiguracao", false, false, false, false));
		listFields.add(new Field("posx", "posx", false, false, false, false));
		listFields.add(new Field("posy", "posy", false, false, false, false));
		listFields.add(new Field("descricao", "descricao", false, false, false, false));
		listFields.add(new Field("icone", "icone", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return "mapanegocioitem";
	}

	/**
	 * Retorna lista de imagens a partir do id do processo de negcio
	 *
	 * @param Integer
	 * @return Collection<MapaNegocioItemDTO>
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 22.09.2015
	 */
	public Collection<MapaNegocioItemDTO> findByIdServicoNegocio(Integer idServicoNegocio) throws Exception {
		Collection<MapaNegocioItemDTO> listMapaNegocioItemDto = new ArrayList<>();

		final List<Condition> condicao = new ArrayList<>();

		condicao.add(new Condition("idServicoNegocio", "=", idServicoNegocio));

		listMapaNegocioItemDto = this.findByCondition(condicao, null);

		return listMapaNegocioItemDto;
	}
	
	
	public Collection<MapaNegocioItemDTO> findByIdItemConfiguracao(Integer idItemConfiguracao)throws Exception{
		Collection<MapaNegocioItemDTO> listMapaNegocioItemDTO = new ArrayList<>();
		final List<Condition> condicao = new ArrayList();
		
		condicao.add(new Condition("idItemConfiguracao", "=", idItemConfiguracao));
		listMapaNegocioItemDTO = this.findByCondition(condicao, null);
		
		return listMapaNegocioItemDTO;
	}

	@Override
	public Class getBean() {
		return MapaNegocioItemDTO.class;
	}

}
