package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.MapaNegocioRelacaoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class MapaNegocioRelacaoDao extends CrudDaoDefaultImpl {

	public MapaNegocioRelacaoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}
	
	@SuppressWarnings("rawtypes")
	@Override
	public Collection find(IDto obj) throws PersistenceException {
		return null;
	}
	
	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idmapanegociorelacao", "idMapaNegocioRelacao", true, true, false, false));
		listFields.add(new Field("idmapanegocioitemfilho", "idMapaNegocioItemFilho", false, false, false, false));
		listFields.add(new Field("idmapanegocioitempai", "idMapaNegocioItemPai", false, false, false, false));
		return listFields;
	}
	@Override
	public String getTableName() {
		return "mapanegociorelacao";
	}
	
	/**
	 * Retorna as relaes(ligaes) dos itens do mapa de negcio a partir do id filho
	 *
	 * @param idMapaNegocioItemFilho
	 * @return Collection<MapaNegocioRelacaoDTO>
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 22.09.2015
	 */
	@SuppressWarnings("unchecked")
	public Collection<MapaNegocioRelacaoDTO> findByIdMapaNegocioItemFilho(Integer idMapaNegocioItemFilho) throws Exception {
		Collection<MapaNegocioRelacaoDTO> listMapaNegocioRelacaoDto = new ArrayList<>();

		if (idMapaNegocioItemFilho > 0) {
			final List<Condition> condicao = new ArrayList<>();

			condicao.add(new Condition("idMapaNegocioItemFilho", "=", idMapaNegocioItemFilho));

			listMapaNegocioRelacaoDto = this.findByCondition(condicao, null);
		}

		return listMapaNegocioRelacaoDto;
	}

	/**
	 * Retorna a ligao de dois itens a partir dos ids do seu pai e do seu filho
	 *
	 * @param idMapaNegocioItemFilho, idMapaNegocioItemPai
	 * @return MapaNegocioRelacaoDTO
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 22.09.2015
	 */
	@SuppressWarnings("unchecked")
	public MapaNegocioRelacaoDTO findByIdMapaNegocioItemFilhoAndIdItemPai(Integer idMapaNegocioItemFilho, Integer idMapaNegocioItemPai) throws Exception {
		Collection<MapaNegocioRelacaoDTO> listProcessoNegocioImagemRelacaoDto = new ArrayList<>();

		if (idMapaNegocioItemFilho > 0 && idMapaNegocioItemPai > 0) {
			final List<Condition> condicao = new ArrayList<>();

			condicao.add(new Condition("idMapaNegocioItemFilho", "=", idMapaNegocioItemFilho));
			condicao.add(new Condition("idMapaNegocioItemPai", "=", idMapaNegocioItemPai));

			listProcessoNegocioImagemRelacaoDto = this.findByCondition(condicao, null);
		}
		
		if (listProcessoNegocioImagemRelacaoDto != null && listProcessoNegocioImagemRelacaoDto.size() > 0) {
			for (MapaNegocioRelacaoDTO relacaoDto : listProcessoNegocioImagemRelacaoDto) {
				//retorna o primeiro da lista
				return relacaoDto;
			}
		}

		return null;
	}

	/**
	 * Antes de remover a imagem de processo de negcio, deletar todas as ligaes que ela era pai.
	 *
	 * @param idMapaNegocioItemPai
	 * @return int
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 22.09.2015
	 */
	public int deleteRelacaoByIdPai(Integer idMapaNegocioItemPai) throws Exception {
		int retornoRemocao = 0;

		if (idMapaNegocioItemPai > 0) {
			final List<Condition> condicaoImgPai = new ArrayList<>();

			condicaoImgPai.add(new Condition("idMapaNegocioItemPai", "=", idMapaNegocioItemPai));

			retornoRemocao = this.deleteByCondition(condicaoImgPai);
		}

		return retornoRemocao;
	}

	/**
	 * Antes de remover a imagem de processo de negcio, deletar todas as ligaes que ela era filho.
	 *
	 * @param idMapaNegocioItemFilho
	 * @return int
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 22.09.2015
	 */
	public int deleteRelacaoByIdFilho(Integer idMapaNegocioItemFilho) throws Exception {
		int retornoRemocao = 0;

		if (idMapaNegocioItemFilho > 0) {
			final List<Condition> condicaoImgFilho = new ArrayList<>();

			condicaoImgFilho.add(new Condition("idMapaNegocioItemFilho", "=", idMapaNegocioItemFilho));

			retornoRemocao = this.deleteByCondition(condicaoImgFilho);
		}

		return retornoRemocao;
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	public Class getBean() {
		return MapaNegocioRelacaoDTO.class;
	}

}
