package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.MatrizContratoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;
/**
 * @author ibimon.morais
 * @25/09/2015
 */
public class MatrizContratoDao extends CrudDaoDefaultImpl {

    public MatrizContratoDao() {
        super(Constantes.getValue("DATABASE_ALIAS"), null);
    }

    @Override
    public Collection<Field> getFields() {
        final Collection<Field> listFields = new ArrayList<>();
        listFields.add(new Field("idmatrizcomunicacao", "idMatrizComunicacao", true, true, false, false));
        listFields.add(new Field("idcontrato", "idContrato", false, false, false, false));
        listFields.add(new Field("grupoenvolvido", "grupoEnvolvido", false, false, false, false));
        listFields.add(new Field("responsabilidades", "responsabilidades", false, false, false, false));
        listFields.add(new Field("idtiporegistro", "idTipoRegistro", false, false, false, false));
        listFields.add(new Field("idfrequencia", "idFrequencia", false, false, false, false));
        listFields.add(new Field("idformacontato", "idFormaContato", false, false, false, false));
        listFields.add(new Field("deleted", "deleted", false, false, false, false));
        return listFields;
    }

    @Override
    public String getTableName() {
        return "matrizcomunicacao";
    }

    @Override
    public Class<MatrizContratoDTO> getBean() {
        return MatrizContratoDTO.class;
    }

    @SuppressWarnings("unchecked")
	public Collection<MatrizContratoDTO> findByIdContrato(final Integer parm) throws PersistenceException {
        final List<Condition> condicao = new ArrayList<>();
        final List<Order> ordenacao = new ArrayList<>();
        condicao.add(new Condition("idContrato", "=", parm));
        ordenacao.add(new Order("idMatrizComunicacao"));
        return super.findByCondition(condicao, ordenacao);
    }
}
