package br.com.centralit.citcorpore.integracao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.MedidaRecuperacaoBaseConhecimentoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class MedidaRecuperacaoBaseConhecimentoDao extends CrudDaoDefaultImpl {

	public MedidaRecuperacaoBaseConhecimentoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "medidarecuperacaobaseconhec";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idMedidaRecuperacaoBaseConhec", "idMedidaRecuperacaoBaseConhecimento", true, true, false, false));
		listFields.add(new Field("idMedidaRecuperacao", "idMedidaRecuperacao", false, false, false, false));
		listFields.add(new Field("idBaseConhecimento", "idBaseConhecimento", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<MedidaRecuperacaoBaseConhecimentoDTO> getBean() {
		return MedidaRecuperacaoBaseConhecimentoDTO.class;
	}

	@SuppressWarnings("unchecked")
	public void deleteByEstrategiaContinuidade(Integer idEstrategiaContinuidade) throws PersistenceException, SQLException {
		List<Integer> param = new ArrayList<Integer>();
		StringBuilder sb = new StringBuilder();

		sb.append("select ");
		sb.append("	idMedidaRecuperacaoBaseConhec ");
		sb.append("from ");
		sb.append("	medidarecuperacaobaseconhec mrbc ");
		sb.append("	inner join medidarecuperacao mr on mrbc.idMedidaRecuperacao = mr.idMedidaRecuperacao and mr.idEstrategiaContinuidade = ?");

		param.add(idEstrategiaContinuidade);

		List<?> list = this.execSQL(sb.toString(), param.toArray());
		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idMedidaRecuperacaoBaseConhecimento");

		if (list != null && !list.isEmpty()) {
			List<MedidaRecuperacaoBaseConhecimentoDTO> listIdsParaExcluir = this.listConvertion(MedidaRecuperacaoBaseConhecimentoDTO.class, list, listRetorno);
			String sqlDelete = "DELETE FROM medidarecuperacaobaseconhec WHERE idmedidarecuperacaobaseconhec in (";

			for (MedidaRecuperacaoBaseConhecimentoDTO objMedida : listIdsParaExcluir) {
				sqlDelete += objMedida.getIdMedidaRecuperacaoBaseConhecimento() + ",";
			}

			sqlDelete = sqlDelete.substring(0, sqlDelete.length() - 1);
			sqlDelete += ")";

			this.getTransactionControler().getConnection().createStatement().executeUpdate(sqlDelete);
		}
	}

	public void updateIdBaseConhecimento(Integer idBaseConhecimentoAntigo, Integer idBaseConhecimentoNovo) throws PersistenceException, SQLException {
		StringBuilder sql = new StringBuilder();
		sql.append("UPDATE ").append(getTableName()).append(" SET idBaseConhecimento = ").append(idBaseConhecimentoNovo).append(" WHERE idBaseConhecimento = ").append(idBaseConhecimentoAntigo);
		this.getTransactionControler().getConnection().createStatement().executeUpdate(sql.toString());
	}

	@SuppressWarnings("unchecked")
	public List<MedidaRecuperacaoBaseConhecimentoDTO> findByIdMedidaRecuperacao(Integer idMedidaRecuperacao) throws PersistenceException {
		List<Integer> param = new ArrayList<Integer>();

		StringBuilder sb = new StringBuilder();
		sb.append("SELECT ");
		sb.append("		medidaRecuperacaoBaseConhec.idMedidaRecuperacaoBaseConhec,");
		sb.append("		baseConhecimento.idBaseConhecimento,");
		sb.append("		baseConhecimento.titulo ");
		sb.append("FROM ");
		sb.append("		baseConhecimento baseConhecimento ");
		sb.append("		INNER JOIN medidaRecuperacaoBaseConhec medidaRecuperacaoBaseConhec ");
		sb.append("			ON baseConhecimento.idBaseConhecimento = medidaRecuperacaoBaseConhec.idBaseConhecimento ");
		sb.append("WHERE ");
		sb.append("		(baseConhecimento.dataFim is null or baseConhecimento.dataFim > {DATAATUAL}) ");
		sb.append("		and medidaRecuperacaoBaseConhec.idMedidaRecuperacao = ? ");
		sb.append("ORDER BY ");
		sb.append("	medidaRecuperacaoBaseConhec.idMedidaRecuperacaoBaseConhec");

		param.add(idMedidaRecuperacao);

		List<?> lista = this.execSQL(sb.toString(), param.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idMedidaRecuperacaoBaseConhecimento");
		listRetorno.add("idBaseConhecimento");
		listRetorno.add("tituloBaseConhecimento");

		List<MedidaRecuperacaoBaseConhecimentoDTO> result = this.engine.listConvertion(getBean(), lista, listRetorno);

		if (result != null && !result.isEmpty()) {
			return result;
		}

		return Collections.emptyList();
	}
}
