package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.MedidaRecuperacaoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class MedidaRecuperacaoDao extends CrudDaoDefaultImpl {

	public MedidaRecuperacaoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public List<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("idMedidaRecuperacao", "idMedidaRecuperacao", true, true, false, false));
		listFields.add(new Field("idEstrategiaContinuidade", "idEstrategiaContinuidade", false, false, false, false));
		listFields.add(new Field("idCenarioRiscoTratativa", "idCenarioRiscoTratativa", false, false, false, false));
		listFields.add(new Field("nome", "nome", false, false, false, false));
		listFields.add(new Field("tipoRecuperacao", "tipoRecuperacao", false, false, false, false));
		listFields.add(new Field("justificativa", "justificativa", false, false, false, false));
		listFields.add(new Field("dataInicio", "dataInicio", false, false, false, false));
		listFields.add(new Field("dataFim", "dataFim", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "medidarecuperacao";
	}

	@Override
	public Class<MedidaRecuperacaoDTO> getBean() {
		return MedidaRecuperacaoDTO.class;
	}

	public void updateNotNull(MedidaRecuperacaoDTO medidaRecuperacaoDto) throws PersistenceException {
		super.updateNotNull(medidaRecuperacaoDto);
	}

	@SuppressWarnings("unchecked")
	public Collection<MedidaRecuperacaoDTO> findByIdEstrategiaContinuidade(Integer idEstrategiaContinuidade) throws PersistenceException {
		List<Condition> condicao = new ArrayList<>();
		condicao.add(new Condition("idEstrategiaContinuidade", idEstrategiaContinuidade));
		condicao.add(new Condition("dataFim", Condition.IS, null));
		return super.findByCondition(condicao, null);
	}

	@SuppressWarnings("unchecked")
	public Collection<MedidaRecuperacaoDTO> findByIdCenarioRiscoTratativa(Integer idCenarioRiscoTratativa) throws PersistenceException {
		List<Condition> condicao = new ArrayList<>();
		condicao.add(new Condition("idCenarioRiscoTratativa", idCenarioRiscoTratativa));
		condicao.add(new Condition("dataFim", Condition.IS, null));
		return super.findByCondition(condicao, null);
	}
}
