package br.com.centralit.citcorpore.integracao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.MedidaRespostaProjetoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class MedidaRespostaProjetoDao extends CrudDaoDefaultImpl {

	public MedidaRespostaProjetoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "medidarespostaprojeto";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idMedidaRespostaProjeto", "idMedidaRespostaProjeto", true, true, false, false));
		listFields.add(new Field("idMedidaResposta", "idMedidaResposta", false, false, false, false));
		listFields.add(new Field("idProjeto", "idProjeto", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<MedidaRespostaProjetoDTO> getBean() {
		return MedidaRespostaProjetoDTO.class;
	}

	@SuppressWarnings("unchecked")
	public void deleteByEstrategiaContinuidade(Integer idEstrategiaContinuidade) throws PersistenceException, SQLException {
		List<Integer> param = new ArrayList<Integer>();
		StringBuilder sb = new StringBuilder();

		sb.append("select ");
		sb.append("	idMedidaRespostaProjeto ");
		sb.append("from ");
		sb.append("	medidarespostaprojeto mrp ");
		sb.append("	inner join medidaresposta mr on mrp.idMedidaResposta = mr.idMedidaResposta and mr.idEstrategiaContinuidade = ?");

		param.add(idEstrategiaContinuidade);

		List<?> list = this.execSQL(sb.toString(), param.toArray());
		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idMedidaRespostaProjeto");

		if (list != null && !list.isEmpty()) {
			List<MedidaRespostaProjetoDTO> listIdsParaExcluir = this.listConvertion(MedidaRespostaProjetoDTO.class, list, listRetorno);
			String sqlDelete = "DELETE FROM medidarespostaprojeto WHERE idmedidarespostaprojeto in (";

			for (MedidaRespostaProjetoDTO objMedida : listIdsParaExcluir) {
				sqlDelete += objMedida.getIdMedidaRespostaProjeto() + ",";
			}

			sqlDelete = sqlDelete.substring(0, sqlDelete.length() - 1);
			sqlDelete += ")";

			this.getTransactionControler().getConnection().createStatement().executeUpdate(sqlDelete);
		}
	}
}
