package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.MudancaBaseConhecimentoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

@SuppressWarnings({"rawtypes","unchecked"})
public class MudancaBaseConhecimentoDao extends CrudDaoDefaultImpl {


	public MudancaBaseConhecimentoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}
	
	private static final String SQL_DELETE = "delete from mudancabaseconhecimento where idbaseconhecimento = ? ";
	private static final String SQL_DELETE_BY_ID_MUDANCA = "delete from mudancabaseconhecimento where idrequisicaomudanca = ? ";
	
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idRequisicaoMudanca" ,"idrequisicaomudanca", true, false, false, false));
		listFields.add(new Field("idBaseConhecimento" ,"idbaseconhecimento", true, false, false, false));
		return listFields;
	}
	
	public String getTableName() {
		return this.getOwner() + "mudancabaseconhecimento";
	}

	public Collection list() throws PersistenceException {
		return null;
	}

	public Class getBean() {
		return MudancaBaseConhecimentoDTO.class;
	}
	
	public Collection find(IDto arg0) throws PersistenceException {
		return null;
	}
	
	public Collection findByIdConhecimento(Integer parm) throws Exception {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idBaseConhecimento", "=", parm)); 
		ordenacao.add(new Order("idBaseConhecimento"));
		return super.findByCondition(condicao, ordenacao);
	}
	
	public void deleteByIdBaseConhecimento(Integer parm) throws Exception {
		 super.execUpdate(SQL_DELETE, new Object[]{parm});
	}
	
	public ArrayList<MudancaBaseConhecimentoDTO> listByIdBaseConhecimento(Integer idBaseConhecimento) throws ServiceException, Exception {
		ArrayList<Condition> condicoes = new ArrayList<Condition>();
		
		condicoes.add(new Condition("idBaseConhecimento", "=", idBaseConhecimento));
		
		return (ArrayList<MudancaBaseConhecimentoDTO>) super.findByCondition(condicoes, null);
	}
	
	public ArrayList<MudancaBaseConhecimentoDTO> listByIdRequisicaMudanca(Integer idRequisicaoMudanca) throws ServiceException, Exception {
		ArrayList<Condition> condicoes = new ArrayList<Condition>();
		
		condicoes.add(new Condition("idRequisicaoMudanca", "=", idRequisicaoMudanca));
		
		return (ArrayList<MudancaBaseConhecimentoDTO>) super.findByCondition(condicoes, null);
	}
	
	public Collection<MudancaBaseConhecimentoDTO> listAll() throws ServiceException, Exception {
		
		StringBuilder sb = new StringBuilder();
		List listRetorno = new ArrayList();

		sb.append("SELECT distinct status ");
		sb.append("FROM mudancabaseconhecimento ");
		
		List lista = this.execSQL(sb.toString(), null);
		listRetorno.add("status");
		
		List listaSolicitacoes = this.engine.listConvertion(getBean(), lista, listRetorno);

		return listaSolicitacoes;
		
	}
	
	public Collection findByIdRequisicaoMudanca(Integer idRequisicaoMudanca) throws Exception {
		
		List parametro = new ArrayList();
		List fields = new ArrayList();
		List list = new ArrayList();
		StringBuilder sql =  new StringBuilder();
		sql.append(" SELECT mbc.idbaseconhecimento, mbc.idrequisicaomudanca, bc.titulo ");
		sql.append(" FROM mudancabaseconhecimento mbc  ");
		sql.append(" inner join historicobaseconhecimento bc on mbc.idbaseconhecimento = bc.idbaseconhecimento ");
		sql.append(" inner join requisicaomudanca rm on mbc.idrequisicaomudanca = rm.idrequisicaomudanca ");
		
		if(idRequisicaoMudanca != null){
			sql.append(" where mbc.idrequisicaomudanca = ? ");
			parametro.add(idRequisicaoMudanca);
		}
		
		list = this.execSQL(sql.toString(), parametro.toArray());
		fields.add("idBaseConhecimento");
		fields.add("idRequisicaoMudanca");
		fields.add("titulo");
		
		if (list != null && !list.isEmpty()) {
			return (List<MudancaBaseConhecimentoDTO>) this.listConvertion(getBean(), list, fields);
		} else {
			return null;
		}		
	}
	
	public void deleteByIdRequisicaoMudanca(Integer idRequisicaoMudanca) throws ServiceException, Exception{
		ArrayList<Condition> condicoes = new ArrayList<Condition>();
		condicoes.add(new Condition("idRequisicaoMudanca", "=", idRequisicaoMudanca));
		super.deleteByCondition(condicoes);
	}
	
	public void deleteByIdMudanca(Integer parm) throws Exception {
		 super.execUpdate(SQL_DELETE_BY_ID_MUDANCA, new Object[]{parm});
	}
	
	
}
